@extends('layouts.admin')

@section('title', 'Class Video Details')
@section('page-title', 'Class Video Details')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>{{ $video->title }}</h3>
            <div style="display: flex; gap: 10px;">
                <a href="{{ route('admin.class-videos.edit', $video->id) }}" class="btn btn-secondary">Edit</a>
                <a href="{{ route('admin.class-videos.index') }}" class="btn btn-secondary">Back</a>
            </div>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-bottom: 30px;">
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Course</strong>
                    <p style="font-size: 16px;">{{ $video->course->name }}</p>
                    <small>{{ $video->course->code }}</small>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Instructor</strong>
                    <p style="font-size: 16px;">{{ $video->instructor->name }}</p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Course Offering</strong>
                    <p style="font-size: 16px;">{{ $video->courseOffering->name ?? 'N/A' }}</p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Session Date</strong>
                    <p style="font-size: 16px;">{{ $video->session_date->format('M d, Y') }}</p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Status</strong>
                    @if($video->is_published)
                        <span style="color: #6bff6b; font-weight: bold;">Published</span>
                    @else
                        <span style="color: #888; font-weight: bold;">Draft</span>
                    @endif
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Views</strong>
                    <p style="font-size: 16px;">{{ $video->views_count }}</p>
                </div>
            </div>
            
            @if($video->description)
                <div style="margin-bottom: 20px;">
                    <strong style="color: #888; display: block; margin-bottom: 10px;">Description</strong>
                    <p style="line-height: 1.6;">{{ $video->description }}</p>
                </div>
            @endif
            
            <div style="border-top: 1px solid #404040; padding-top: 20px;">
                <h4 style="margin-bottom: 15px;">Video Details</h4>
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 15px;">
                    @if($video->mega_storage_link)
                        <div>
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Mega Storage Link</strong>
                            <a href="{{ $video->mega_storage_link }}" target="_blank" style="color: #4a9eff; word-break: break-all;">{{ $video->mega_storage_link }}</a>
                        </div>
                    @endif
                    @if($video->download_key)
                        <div>
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Download Key</strong>
                            <p style="font-family: monospace;">{{ $video->download_key }}</p>
                        </div>
                    @endif
                    @if($video->video_duration)
                        <div>
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Duration</strong>
                            <p>{{ $video->video_duration }}</p>
                        </div>
                    @endif
                    @if($video->thumbnail_url)
                        <div>
                            <strong style="color: #888; display: block; margin-bottom: 5px;">Thumbnail</strong>
                            <img src="{{ $video->thumbnail_url }}" alt="Thumbnail" style="max-width: 200px; border-radius: 5px;">
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection

