@extends('layouts.admin')

@section('title', 'Class Videos')
@section('page-title', 'Class Videos Management')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Class Videos</h3>
            <a href="{{ route('admin.class-videos.create') }}" class="btn btn-primary">Add New Video</a>
        </div>
        
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('admin.class-videos.index') }}" style="display: flex; gap: 10px;">
                <input type="text" name="search" placeholder="Search videos..." value="{{ request('search') }}" style="flex: 1; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                <select name="course_id" style="padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                    <option value="">All Courses</option>
                    @foreach($courses as $course)
                        <option value="{{ $course->id }}" {{ request('course_id') == $course->id ? 'selected' : '' }}>{{ $course->name }}</option>
                    @endforeach
                </select>
                <button type="submit" class="btn btn-primary">Search</button>
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($videos->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Course</th>
                            <th>Instructor</th>
                            <th>Session Date</th>
                            <th>Status</th>
                            <th>Views</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($videos as $video)
                            <tr>
                                <td><strong>{{ $video->title }}</strong></td>
                                <td>{{ $video->course->name }}</td>
                                <td>{{ $video->instructor->name }}</td>
                                <td>{{ $video->session_date->format('M d, Y') }}</td>
                                <td>
                                    @if($video->is_published)
                                        <span style="color: #6bff6b;">Published</span>
                                    @else
                                        <span style="color: #888;">Draft</span>
                                    @endif
                                </td>
                                <td>{{ $video->views_count }}</td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="{{ route('admin.class-videos.show', $video->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="{{ route('admin.class-videos.edit', $video->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div style="margin-top: 20px;">{{ $videos->links() }}</div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No class videos found.</p>
                    <a href="{{ route('admin.class-videos.create') }}" class="btn btn-primary" style="margin-top: 15px;">Add First Video</a>
                </div>
            @endif
        </div>
    </div>
@endsection

