@extends('layouts.admin')

@section('title', 'Edit Class Video')
@section('page-title', 'Edit Class Video')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Edit Class Video</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.class-videos.update', $video->id) }}">
                @csrf
                @method('PUT')
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="course_id">Course *</label>
                        <select id="course_id" name="course_id" required>
                            <option value="">Select Course</option>
                            @foreach($courses as $course)
                                <option value="{{ $course->id }}" {{ (old('course_id', $video->course_id) == $course->id) ? 'selected' : '' }}>
                                    {{ $course->name }} ({{ $course->code }}) - {{ $course->instructor->name ?? 'No Instructor' }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="course_offering_id">Course Offering</label>
                        <select id="course_offering_id" name="course_offering_id">
                            <option value="">None</option>
                            @foreach($offerings as $offering)
                                <option value="{{ $offering->id }}" {{ (old('course_offering_id', $video->course_offering_id) == $offering->id) ? 'selected' : '' }}>
                                    {{ $offering->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <div style="margin-top: 20px;">
                    <div class="form-group">
                        <label for="title">Video Title *</label>
                        <input type="text" id="title" name="title" value="{{ old('title', $video->title) }}" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea id="description" name="description" rows="4">{{ old('description', $video->description) }}</textarea>
                    </div>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                    <div class="form-group">
                        <label for="session_date">Session Date *</label>
                        <input type="date" id="session_date" name="session_date" value="{{ old('session_date', $video->session_date->format('Y-m-d')) }}" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="video_duration">Video Duration</label>
                        <input type="text" id="video_duration" name="video_duration" value="{{ old('video_duration', $video->video_duration) }}" placeholder="e.g., 01:30:00">
                    </div>
                </div>
                
                <div style="margin-top: 20px;">
                    <div class="form-group">
                        <label for="mega_storage_link">Mega Storage Link *</label>
                        <input type="url" id="mega_storage_link" name="mega_storage_link" value="{{ old('mega_storage_link', $video->mega_storage_link) }}" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="download_key">Download Key</label>
                        <input type="text" id="download_key" name="download_key" value="{{ old('download_key', $video->download_key) }}">
                    </div>
                    
                    <div class="form-group">
                        <label for="thumbnail_url">Thumbnail URL</label>
                        <input type="url" id="thumbnail_url" name="thumbnail_url" value="{{ old('thumbnail_url', $video->thumbnail_url) }}">
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                        <input type="checkbox" id="is_published" name="is_published" value="1" {{ old('is_published', $video->is_published) ? 'checked' : '' }}>
                        <span>Publish this video</span>
                    </label>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 15px;">
                    <button type="submit" class="btn btn-primary">Update Video</button>
                    <a href="{{ route('admin.class-videos.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

