@extends('layouts.admin')

@section('title', 'Add Class Video')
@section('page-title', 'Add New Class Video')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Create New Class Video</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.class-videos.store') }}">
                @csrf
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="course_id">Course *</label>
                        <select id="course_id" name="course_id" required>
                            <option value="">Select Course</option>
                            @foreach($courses as $course)
                                <option value="{{ $course->id }}" {{ old('course_id') == $course->id ? 'selected' : '' }}>
                                    {{ $course->name }} ({{ $course->code }}) - {{ $course->instructor->name ?? 'No Instructor' }}
                                </option>
                            @endforeach
                        </select>
                        @error('course_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="course_offering_id">Course Offering (Optional)</label>
                        <select id="course_offering_id" name="course_offering_id">
                            <option value="">Select Offering (Optional)</option>
                            @foreach($offerings as $offering)
                                <option value="{{ $offering->id }}" {{ old('course_offering_id') == $offering->id ? 'selected' : '' }}>
                                    {{ $offering->name }} - {{ $offering->course->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('course_offering_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div style="margin-top: 20px;">
                    <div class="form-group">
                        <label for="title">Video Title *</label>
                        <input 
                            type="text" 
                            id="title" 
                            name="title" 
                            value="{{ old('title') }}" 
                            required
                            autofocus
                            placeholder="e.g., Introduction to Flutter - Session 1"
                        >
                        @error('title')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="description">Description</label>
                        <textarea 
                            id="description" 
                            name="description" 
                            rows="4"
                            placeholder="Video description or session notes..."
                        >{{ old('description') }}</textarea>
                        @error('description')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                    <div class="form-group">
                        <label for="session_date">Session Date *</label>
                        <input 
                            type="date" 
                            id="session_date" 
                            name="session_date" 
                            value="{{ old('session_date', date('Y-m-d')) }}" 
                            required
                        >
                        @error('session_date')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="video_duration">Video Duration (HH:MM:SS)</label>
                        <input 
                            type="text" 
                            id="video_duration" 
                            name="video_duration" 
                            value="{{ old('video_duration') }}" 
                            placeholder="e.g., 01:30:00"
                        >
                        @error('video_duration')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div style="margin-top: 20px;">
                    <div class="form-group">
                        <label for="mega_storage_link">Mega Storage Link *</label>
                        <input 
                            type="url" 
                            id="mega_storage_link" 
                            name="mega_storage_link" 
                            value="{{ old('mega_storage_link') }}" 
                            required
                            placeholder="https://mega.nz/..."
                        >
                        @error('mega_storage_link')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="download_key">Download Key (Optional)</label>
                        <input 
                            type="text" 
                            id="download_key" 
                            name="download_key" 
                            value="{{ old('download_key') }}" 
                            placeholder="Mega download key if required"
                        >
                        @error('download_key')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="thumbnail_url">Thumbnail URL (Optional)</label>
                        <input 
                            type="url" 
                            id="thumbnail_url" 
                            name="thumbnail_url" 
                            value="{{ old('thumbnail_url') }}" 
                            placeholder="https://..."
                        >
                        @error('thumbnail_url')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                        <input 
                            type="checkbox" 
                            id="is_published" 
                            name="is_published" 
                            value="1"
                            {{ old('is_published') ? 'checked' : '' }}
                        >
                        <span>Publish this video</span>
                    </label>
                    @error('is_published')
                        <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                    @enderror
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 15px;">
                    <button type="submit" class="btn btn-primary">Create Video</button>
                    <a href="{{ route('admin.class-videos.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

