@extends('layouts.admin')

@section('title', 'Certificate Details')
@section('page-title', 'Certificate Details')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>{{ $certificate->title }}</h3>
            <div style="display: flex; gap: 10px;">
                <a href="{{ route('admin.certificates.edit', $certificate->id) }}" class="btn btn-secondary">Edit</a>
                <a href="{{ route('admin.certificates.index') }}" class="btn btn-secondary">Back</a>
            </div>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-bottom: 30px;">
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Student</strong>
                    <p style="font-size: 16px;">{{ $certificate->student->name }}</p>
                    <small>{{ $certificate->student->school_id ?? 'N/A' }}</small>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Course</strong>
                    <p style="font-size: 16px;">{{ $certificate->course->name ?? 'N/A' }}</p>
                    @if($certificate->course)
                        <small>{{ $certificate->course->code }}</small>
                    @endif
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Course Offering</strong>
                    <p style="font-size: 16px;">{{ $certificate->courseOffering->name ?? 'N/A' }}</p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Certificate Type</strong>
                    <p style="font-size: 16px;">{{ ucfirst($certificate->certificate_type) }}</p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Issued Date</strong>
                    <p style="font-size: 16px;">{{ $certificate->issued_date->format('M d, Y') }}</p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Issued By</strong>
                    <p style="font-size: 16px;">{{ $certificate->issuedBy->name }}</p>
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Status</strong>
                    @if($certificate->is_active)
                        <span style="color: #6bff6b; font-weight: bold;">Active</span>
                    @else
                        <span style="color: #888; font-weight: bold;">Inactive</span>
                    @endif
                </div>
                <div>
                    <strong style="color: #888; display: block; margin-bottom: 5px;">Downloads</strong>
                    <p style="font-size: 16px;">{{ $certificate->download_count }}</p>
                </div>
            </div>
            
            @if($certificate->description)
                <div style="margin-bottom: 20px;">
                    <strong style="color: #888; display: block; margin-bottom: 10px;">Description</strong>
                    <p style="line-height: 1.6;">{{ $certificate->description }}</p>
                </div>
            @endif
            
            <div style="border-top: 1px solid #404040; padding-top: 20px;">
                <h4 style="margin-bottom: 15px;">Certificate File</h4>
                <div style="background: #1a1a1a; padding: 15px; border-radius: 5px; display: flex; justify-content: space-between; align-items: center;">
                    <div>
                        <strong>{{ $certificate->file_name }}</strong>
                        <small style="display: block; color: #888; margin-top: 5px;">
                            {{ number_format($certificate->file_size / 1024, 2) }} KB
                        </small>
                    </div>
                    <a href="{{ asset('storage/' . $certificate->file_path) }}" target="_blank" class="btn btn-primary">Download Certificate</a>
                </div>
            </div>
        </div>
    </div>
@endsection

