@extends('layouts.admin')

@section('title', 'Certificates')
@section('page-title', 'Certificates Management')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Certificates</h3>
            <a href="{{ route('admin.certificates.create') }}" class="btn btn-primary">Issue New Certificate</a>
        </div>
        
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('admin.certificates.index') }}" style="display: flex; gap: 10px;">
                <input type="text" name="search" placeholder="Search certificates..." value="{{ request('search') }}" style="flex: 1; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;">
                <button type="submit" class="btn btn-primary">Search</button>
            </form>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            @if($certificates->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Title</th>
                            <th>Student</th>
                            <th>Course</th>
                            <th>Type</th>
                            <th>Issued Date</th>
                            <th>Issued By</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($certificates as $certificate)
                            <tr>
                                <td><strong>{{ $certificate->title }}</strong></td>
                                <td>{{ $certificate->student->name }}</td>
                                <td>{{ $certificate->course->name ?? 'N/A' }}</td>
                                <td>{{ ucfirst($certificate->certificate_type) }}</td>
                                <td>{{ $certificate->issued_date->format('M d, Y') }}</td>
                                <td>{{ $certificate->issuedBy->name }}</td>
                                <td>
                                    @if($certificate->is_active)
                                        <span style="color: #6bff6b;">Active</span>
                                    @else
                                        <span style="color: #888;">Inactive</span>
                                    @endif
                                </td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="{{ route('admin.certificates.show', $certificate->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        <a href="{{ route('admin.certificates.edit', $certificate->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div style="margin-top: 20px;">{{ $certificates->links() }}</div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No certificates found.</p>
                    <a href="{{ route('admin.certificates.create') }}" class="btn btn-primary" style="margin-top: 15px;">Issue First Certificate</a>
                </div>
            @endif
        </div>
    </div>
@endsection

