@extends('layouts.admin')

@section('title', 'Edit Certificate')
@section('page-title', 'Edit Certificate')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Edit Certificate</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.certificates.update', $certificate->id) }}" enctype="multipart/form-data">
                @csrf
                @method('PUT')
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="student_id">Student *</label>
                        <select id="student_id" name="student_id" required>
                            <option value="">Select Student</option>
                            @foreach($students as $student)
                                <option value="{{ $student->id }}" {{ (old('student_id', $certificate->student_id) == $student->id) ? 'selected' : '' }}>
                                    {{ $student->name }} {{ $student->school_id ? '(' . $student->school_id . ')' : '' }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="course_id">Course</label>
                        <select id="course_id" name="course_id">
                            <option value="">None</option>
                            @foreach($courses as $course)
                                <option value="{{ $course->id }}" {{ (old('course_id', $certificate->course_id) == $course->id) ? 'selected' : '' }}>
                                    {{ $course->name }} ({{ $course->code }})
                                </option>
                            @endforeach
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="course_offering_id">Course Offering</label>
                        <select id="course_offering_id" name="course_offering_id">
                            <option value="">None</option>
                            @foreach($offerings as $offering)
                                <option value="{{ $offering->id }}" {{ (old('course_offering_id', $certificate->course_offering_id) == $offering->id) ? 'selected' : '' }}>
                                    {{ $offering->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
                <div style="margin-top: 20px;">
                    <div class="form-group">
                        <label for="title">Certificate Title *</label>
                        <input type="text" id="title" name="title" value="{{ old('title', $certificate->title) }}" required>
                    </div>
                    
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                        <div class="form-group">
                            <label for="certificate_type">Certificate Type</label>
                            <select id="certificate_type" name="certificate_type">
                                <option value="completion" {{ old('certificate_type', $certificate->certificate_type) == 'completion' ? 'selected' : '' }}>Completion</option>
                                <option value="achievement" {{ old('certificate_type', $certificate->certificate_type) == 'achievement' ? 'selected' : '' }}>Achievement</option>
                                <option value="participation" {{ old('certificate_type', $certificate->certificate_type) == 'participation' ? 'selected' : '' }}>Participation</option>
                                <option value="excellence" {{ old('certificate_type', $certificate->certificate_type) == 'excellence' ? 'selected' : '' }}>Excellence</option>
                            </select>
                        </div>
                        
                        <div class="form-group">
                            <label for="issued_date">Issued Date *</label>
                            <input type="date" id="issued_date" name="issued_date" value="{{ old('issued_date', $certificate->issued_date->format('Y-m-d')) }}" required>
                        </div>
                    </div>
                    
                    <div class="form-group" style="margin-top: 20px;">
                        <label for="file">Certificate File (PDF) - Leave empty to keep current file</label>
                        <input type="file" id="file" name="file" accept=".pdf">
                        <small style="color: #888; display: block; margin-top: 5px;">Current file: {{ $certificate->file_name }} ({{ number_format($certificate->file_size / 1024, 2) }} KB)</small>
                    </div>
                    
                    <div class="form-group" style="margin-top: 20px;">
                        <label for="description">Description</label>
                        <textarea id="description" name="description" rows="4">{{ old('description', $certificate->description) }}</textarea>
                    </div>
                </div>
                
                <div class="form-group" style="margin-top: 20px;">
                    <label style="display: flex; align-items: center; gap: 10px; cursor: pointer;">
                        <input type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $certificate->is_active) ? 'checked' : '' }}>
                        <span>Active</span>
                    </label>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 15px;">
                    <button type="submit" class="btn btn-primary">Update Certificate</button>
                    <a href="{{ route('admin.certificates.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

