@extends('layouts.admin')

@section('title', 'Issue Certificate')
@section('page-title', 'Issue New Certificate')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3>Issue New Certificate</h3>
        </div>
        
        <div style="padding: 0 30px 30px 30px;">
            <form method="POST" action="{{ route('admin.certificates.store') }}" enctype="multipart/form-data">
                @csrf
                
                <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
                    <div class="form-group">
                        <label for="student_id">Student *</label>
                        <select id="student_id" name="student_id" required>
                            <option value="">Select Student</option>
                            @foreach($students as $student)
                                <option value="{{ $student->id }}" {{ old('student_id') == $student->id ? 'selected' : '' }}>
                                    {{ $student->name }} {{ $student->school_id ? '(' . $student->school_id . ')' : '' }}
                                </option>
                            @endforeach
                        </select>
                        @error('student_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="course_id">Course (Optional)</label>
                        <select id="course_id" name="course_id">
                            <option value="">Select Course (Optional)</option>
                            @foreach($courses as $course)
                                <option value="{{ $course->id }}" {{ old('course_id') == $course->id ? 'selected' : '' }}>
                                    {{ $course->name }} ({{ $course->code }})
                                </option>
                            @endforeach
                        </select>
                        @error('course_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group">
                        <label for="course_offering_id">Course Offering (Optional)</label>
                        <select id="course_offering_id" name="course_offering_id">
                            <option value="">Select Offering (Optional)</option>
                            @foreach($offerings as $offering)
                                <option value="{{ $offering->id }}" {{ old('course_offering_id') == $offering->id ? 'selected' : '' }}>
                                    {{ $offering->name }} - {{ $offering->course->name }}
                                </option>
                            @endforeach
                        </select>
                        @error('course_offering_id')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div style="margin-top: 20px;">
                    <div class="form-group">
                        <label for="title">Certificate Title *</label>
                        <input 
                            type="text" 
                            id="title" 
                            name="title" 
                            value="{{ old('title') }}" 
                            required
                            autofocus
                            placeholder="e.g., Certificate of Completion - Mobile App Development"
                        >
                        @error('title')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin-top: 20px;">
                        <div class="form-group">
                            <label for="certificate_type">Certificate Type</label>
                            <select id="certificate_type" name="certificate_type">
                                <option value="completion" {{ old('certificate_type', 'completion') == 'completion' ? 'selected' : '' }}>Completion</option>
                                <option value="achievement" {{ old('certificate_type') == 'achievement' ? 'selected' : '' }}>Achievement</option>
                                <option value="participation" {{ old('certificate_type') == 'participation' ? 'selected' : '' }}>Participation</option>
                                <option value="excellence" {{ old('certificate_type') == 'excellence' ? 'selected' : '' }}>Excellence</option>
                            </select>
                            @error('certificate_type')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                        
                        <div class="form-group">
                            <label for="issued_date">Issued Date *</label>
                            <input 
                                type="date" 
                                id="issued_date" 
                                name="issued_date" 
                                value="{{ old('issued_date', date('Y-m-d')) }}" 
                                required
                            >
                            @error('issued_date')
                                <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    
                    <div class="form-group" style="margin-top: 20px;">
                        <label for="file">Certificate File (PDF) *</label>
                        <input 
                            type="file" 
                            id="file" 
                            name="file" 
                            accept=".pdf"
                            required
                        >
                        <small style="color: #888; display: block; margin-top: 5px;">Maximum file size: 10MB</small>
                        @error('file')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                    
                    <div class="form-group" style="margin-top: 20px;">
                        <label for="description">Description (Optional)</label>
                        <textarea 
                            id="description" 
                            name="description" 
                            rows="4"
                            placeholder="Additional notes or description..."
                        >{{ old('description') }}</textarea>
                        @error('description')
                            <span style="color: #ff6b6b; font-size: 12px; margin-top: 5px; display: block;">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
                
                <div style="margin-top: 30px; display: flex; gap: 15px;">
                    <button type="submit" class="btn btn-primary">Issue Certificate</button>
                    <a href="{{ route('admin.certificates.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

