@extends('layouts.admin')

@section('title', 'Admin Details')
@section('page-title', 'Admin Details')

@section('content')
    <div style="display: flex; gap: 15px; margin-bottom: 20px;">
        <a href="{{ route('admin.admins.index') }}" class="btn btn-secondary">← Back to List</a>
        @if($admin->id !== auth()->id())
            <a href="{{ route('admin.admins.edit', $admin->id) }}" class="btn btn-primary">Edit Admin</a>
        @endif
    </div>
    
    <div class="card">
        <div class="card-header">
            <h3>{{ $admin->name }}
                @if($admin->id === auth()->id())
                    <span style="color: #4a9eff; font-size: 14px; font-weight: normal;">(Your Account)</span>
                @endif
            </h3>
        </div>
        
        <div style="padding: 30px;">
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px;">
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Personal Information</h4>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Full Name</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $admin->name }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Email Address</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $admin->email }}</span>
                    </div>
                    @if($admin->phone)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Phone Number</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $admin->phone }}</span>
                    </div>
                    @endif
                </div>
                
                <div>
                    <h4 style="color: #4a9eff; margin-bottom: 20px; border-bottom: 1px solid #404040; padding-bottom: 10px;">Additional Information</h4>
                    @if($admin->address)
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Address</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $admin->address }}</span>
                    </div>
                    @endif
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Account Status</strong>
                        <span style="color: #6bff6b; font-size: 16px; font-weight: 600;">Active</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Registered On</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $admin->created_at->format('F d, Y h:i A') }}</span>
                    </div>
                    <div style="margin-bottom: 15px;">
                        <strong style="color: #888; display: block; margin-bottom: 5px;">Last Updated</strong>
                        <span style="color: #e0e0e0; font-size: 16px;">{{ $admin->updated_at->format('F d, Y h:i A') }}</span>
                    </div>
                </div>
            </div>
            
            <!-- Action Buttons -->
            @if($admin->id !== auth()->id())
            <div style="margin-top: 30px; padding-top: 30px; border-top: 1px solid #404040; display: flex; gap: 15px;">
                <a href="{{ route('admin.admins.edit', $admin->id) }}" class="btn btn-primary">Edit Admin</a>
                <button type="button" onclick="openConfirmationModal('Delete Admin', 'Are you sure you want to delete {{ addslashes($admin->name) }}? This action cannot be undone and all associated data will be permanently removed.', '{{ route('admin.admins.destroy', $admin->id) }}', 'DELETE')" class="btn btn-secondary" style="background: #dc3545; border: none;">
                    <i class="fas fa-trash"></i> Delete Admin
                </button>
            </div>
            @endif
        </div>
    </div>
@endsection

