@extends('layouts.admin')

@section('title', 'Admins')
@section('page-title', 'Admin Management')

@section('content')
    <div class="card">
        <div class="card-header" style="display: flex; justify-content: space-between; align-items: center;">
            <h3>All Admins</h3>
            <a href="{{ route('admin.admins.create') }}" class="btn btn-primary">Add New Admin</a>
        </div>
        
        <!-- Search Form -->
        <div style="padding: 0 30px 20px 30px;">
            <form method="GET" action="{{ route('admin.admins.index') }}" style="display: flex; gap: 10px;">
                <input 
                    type="text" 
                    name="search" 
                    placeholder="Search by name, email, or phone..." 
                    value="{{ request('search') }}"
                    style="flex: 1; padding: 10px; background: #1a1a1a; border: 1px solid #404040; border-radius: 5px; color: #e0e0e0;"
                >
                <button type="submit" class="btn btn-primary">Search</button>
                @if(request('search'))
                    <a href="{{ route('admin.admins.index') }}" class="btn btn-secondary">Clear</a>
                @endif
            </form>
        </div>
        
        <!-- Admins Table -->
        <div style="padding: 0 30px 30px 30px;">
            @if($admins->count() > 0)
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Registered</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($admins as $admin)
                            <tr>
                                <td>
                                    <strong>{{ $admin->name }}</strong>
                                    @if($admin->id === auth()->id())
                                        <span style="color: #4a9eff; font-size: 12px; margin-left: 8px;">(You)</span>
                                    @endif
                                </td>
                                <td>{{ $admin->email }}</td>
                                <td>{{ $admin->phone ?? 'N/A' }}</td>
                                <td>{{ $admin->created_at->format('M d, Y') }}</td>
                                <td>
                                    <div style="display: flex; gap: 8px;">
                                        <a href="{{ route('admin.admins.show', $admin->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">View</a>
                                        @if($admin->id !== auth()->id())
                                            <a href="{{ route('admin.admins.edit', $admin->id) }}" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px;">Edit</a>
                                            <button type="button" onclick="openConfirmationModal('Delete Admin', 'Are you sure you want to delete {{ addslashes($admin->name) }}? This action cannot be undone.', '{{ route('admin.admins.destroy', $admin->id) }}', 'DELETE')" class="btn btn-secondary" style="padding: 6px 12px; font-size: 12px; background: #dc3545; border: none;">
                                                <i class="fas fa-trash"></i> Delete
                                            </button>
                                        @else
                                            <span style="color: #888; font-size: 12px; padding: 6px 12px;">Cannot edit self</span>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                
                <!-- Pagination -->
                <div style="margin-top: 20px;">
                    {{ $admins->links() }}
                </div>
            @else
                <div style="text-align: center; padding: 40px; color: #888;">
                    <p>No admins found.</p>
                    <a href="{{ route('admin.admins.create') }}" class="btn btn-primary" style="margin-top: 15px;">Add First Admin</a>
                </div>
            @endif
        </div>
    </div>
@endsection

@section('styles')
<style>
    .pagination {
        display: flex;
        gap: 8px;
        justify-content: center;
        list-style: none;
        padding: 0;
    }
    
    .pagination li {
        display: inline-block;
    }
    
    .pagination a, .pagination span {
        padding: 8px 12px;
        background: #2d2d2d;
        border: 1px solid #404040;
        border-radius: 5px;
        color: #e0e0e0;
        text-decoration: none;
        display: inline-block;
    }
    
    .pagination a:hover {
        background: #4a9eff;
        border-color: #4a9eff;
    }
    
    .pagination .active span {
        background: #4a9eff;
        border-color: #4a9eff;
        color: white;
    }
</style>
@endsection

