<?php

/**
 * cPanel-Friendly Deployment Script
 * 
 * This script is optimized for cPanel hosting environments.
 * Run this script on your server after extracting the update package.
 * 
 * Usage: php deploy-cpanel.php
 *        OR: /usr/bin/php81 deploy-cpanel.php (if using specific PHP version)
 */

echo "========================================\n";
echo "AFRILEN PORTAL - cPanel DEPLOYMENT\n";
echo "========================================\n\n";

// Check if running from correct directory
if (!file_exists('artisan')) {
    die("ERROR: Please run this script from your Laravel project root directory.\n");
}

// Check PHP version
$phpVersion = PHP_VERSION;
echo "PHP Version: $phpVersion\n";
if (version_compare($phpVersion, '8.1.0', '<')) {
    echo "⚠ WARNING: PHP 8.1+ recommended. Current: $phpVersion\n";
    echo "Continue anyway? (This may cause issues)\n";
}

// Step 1: Backup current .env
echo "\n[Step 1/8] Backing up .env file...\n";
if (file_exists('.env')) {
    $backupName = '.env.backup.' . date('Y-m-d-His');
    if (copy('.env', $backupName)) {
        echo "✓ .env backed up to: $backupName\n";
    } else {
        echo "⚠ WARNING: Could not backup .env file\n";
    }
} else {
    echo "⚠ WARNING: .env file not found. Make sure it exists!\n";
}

// Step 2: Set permissions
echo "\n[Step 2/8] Setting file permissions...\n";
$directories = ['storage', 'bootstrap/cache'];
foreach ($directories as $dir) {
    if (is_dir($dir)) {
        chmod($dir, 0755);
        // Recursively set permissions
        $iterator = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS),
            RecursiveIteratorIterator::SELF_FIRST
        );
        foreach ($iterator as $item) {
            chmod($item, 0755);
        }
        echo "✓ Permissions set for: $dir\n";
    } else {
        echo "⚠ WARNING: Directory not found: $dir\n";
    }
}

// Step 3: Find Composer
echo "\n[Step 3/8] Finding Composer...\n";
$composerPaths = [
    'composer',
    '/usr/local/bin/composer',
    '/opt/cpanel/composer/bin/composer',
    'composer.phar'
];

$composerCmd = null;
foreach ($composerPaths as $path) {
    $output = [];
    $returnVar = 0;
    exec("$path --version 2>&1", $output, $returnVar);
    if ($returnVar === 0 && !empty($output)) {
        $composerCmd = $path;
        echo "✓ Composer found: $path\n";
        break;
    }
}

if (!$composerCmd) {
    echo "⚠ WARNING: Composer not found in standard paths.\n";
    echo "You may need to install it or use full path.\n";
    echo "Trying to continue with 'composer' command...\n";
    $composerCmd = 'composer';
}

// Step 4: Install dependencies
echo "\n[Step 4/8] Installing dependencies (this may take a few minutes)...\n";
$output = [];
$returnVar = 0;
exec("$composerCmd install --no-dev --optimize-autoloader 2>&1", $output, $returnVar);
if ($returnVar !== 0) {
    echo "⚠ WARNING: Composer install had issues:\n";
    echo implode("\n", array_slice($output, -10)) . "\n";
    echo "\nYou may need to run manually:\n";
    echo "  $composerCmd install --no-dev --optimize-autoloader\n";
} else {
    echo "✓ Dependencies installed successfully\n";
}

// Step 5: Generate application key (if needed)
echo "\n[Step 5/8] Checking application key...\n";
if (!file_exists('.env')) {
    echo "⚠ WARNING: .env file not found. Skipping key generation.\n";
} else {
    $envContent = file_get_contents('.env');
    if (strpos($envContent, 'APP_KEY=') === false || 
        strpos($envContent, 'APP_KEY=base64:') === false && 
        strpos($envContent, 'APP_KEY=') !== false && 
        trim(explode('APP_KEY=', $envContent)[1]) === '') {
        echo "Generating application key...\n";
        exec('php artisan key:generate --force 2>&1', $keyOutput, $keyReturn);
        if ($keyReturn === 0) {
            echo "✓ Application key generated\n";
        } else {
            echo "⚠ Could not generate key automatically. Run: php artisan key:generate\n";
        }
    } else {
        echo "✓ Application key already exists\n";
    }
}

// Step 6: Run migrations
echo "\n[Step 6/8] Running database migrations (SAFE - won't break existing data)...\n";
$output = [];
$returnVar = 0;
exec('php artisan migrate:status 2>&1', $output, $returnVar);
if ($returnVar === 0) {
    echo "Checking migration status...\n";
    exec('php artisan migrate --force 2>&1', $migrateOutput, $migrateReturn);
    if ($migrateReturn === 0) {
        echo "✓ Migrations completed\n";
    } else {
        echo "⚠ Migration output:\n";
        echo implode("\n", array_slice($migrateOutput, -15)) . "\n";
        echo "\nYou may need to run manually: php artisan migrate --force\n";
    }
} else {
    echo "⚠ Could not check migration status. Database connection issue?\n";
    echo "Output: " . implode("\n", array_slice($output, -5)) . "\n";
}

// Step 7: Clear caches
echo "\n[Step 7/8] Clearing all caches...\n";
$cacheCommands = [
    'php artisan cache:clear',
    'php artisan config:clear',
    'php artisan route:clear',
    'php artisan view:clear',
];

foreach ($cacheCommands as $cmd) {
    exec("$cmd 2>&1", $output, $returnVar);
    // Don't show output unless there's an error
}

echo "✓ Caches cleared\n";

// Step 8: Rebuild optimized caches
echo "\n[Step 8/8] Rebuilding optimized caches for production...\n";
$optimizeCommands = [
    'php artisan config:cache',
    'php artisan route:cache',
    'php artisan view:cache',
];

foreach ($optimizeCommands as $cmd) {
    exec("$cmd 2>&1", $output, $returnVar);
    if ($returnVar !== 0) {
        echo "⚠ Warning: $cmd had issues\n";
    }
}

echo "✓ Optimized caches rebuilt\n";

// Step 9: Create storage link
echo "\n[Bonus] Creating storage link...\n";
exec('php artisan storage:link 2>&1', $linkOutput, $linkReturn);
if ($linkReturn === 0) {
    echo "✓ Storage link created\n";
} else {
    // Link might already exist, which is fine
    if (strpos(implode(' ', $linkOutput), 'already exists') !== false) {
        echo "✓ Storage link already exists\n";
    } else {
        echo "⚠ Could not create storage link. Run: php artisan storage:link\n";
    }
}

// Final summary
echo "\n========================================\n";
echo "DEPLOYMENT COMPLETE!\n";
echo "========================================\n\n";

echo "Next steps:\n";
echo "1. Verify deployment: php artisan --version\n";
echo "2. Check logs: tail -n 50 storage/logs/laravel.log\n";
echo "3. Test your API endpoints\n";
echo "4. Verify website loads correctly\n\n";

echo "If you encounter issues:\n";
echo "- Check storage/logs/laravel.log for errors\n";
echo "- Verify .env file has correct database credentials\n";
echo "- Ensure file permissions are correct (755 for storage/)\n";
echo "- Verify PHP version is 8.1+\n\n";

echo "========================================\n";

