<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Quiz;
use App\Models\QuizQuestion;
use App\Models\QuizAnswer;
use App\Models\Book;
use App\Models\User;

class QuizSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Get Flutter book
        $flutterBook = Book::where('title', 'like', '%Flutter%')->first();
        
        // Get first admin user for created_by
        $admin = User::where('role', 'admin')->first();
        if (!$admin) {
            $admin = User::first();
        }

        // Level 1: Beginner Questions (30+)
        $beginnerQuiz = Quiz::create([
            'title' => 'Flutter Basics - Beginner Level',
            'description' => 'Test your knowledge of Flutter fundamentals including widgets, state management, and basic concepts.',
            'book_id' => $flutterBook ? $flutterBook->id : null,
            'level' => 1,
            'is_active' => true,
            'created_by' => $admin->id,
        ]);

        $beginnerQuestions = [
            [
                'question' => 'What is Flutter?',
                'explanation' => 'Flutter is Google\'s UI toolkit for building natively compiled applications for mobile, web, and desktop from a single codebase.',
                'answers' => [
                    ['text' => 'A programming language', 'is_correct' => false],
                    ['text' => 'A UI toolkit for building cross-platform apps', 'is_correct' => true],
                    ['text' => 'A database management system', 'is_correct' => false],
                    ['text' => 'A web framework', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What programming language does Flutter use?',
                'explanation' => 'Flutter uses Dart as its programming language, which was also developed by Google.',
                'answers' => [
                    ['text' => 'JavaScript', 'is_correct' => false],
                    ['text' => 'Python', 'is_correct' => false],
                    ['text' => 'Dart', 'is_correct' => true],
                    ['text' => 'Java', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is a Widget in Flutter?',
                'explanation' => 'In Flutter, everything is a widget. Widgets are the basic building blocks of Flutter applications.',
                'answers' => [
                    ['text' => 'A database table', 'is_correct' => false],
                    ['text' => 'A basic building block of Flutter UI', 'is_correct' => true],
                    ['text' => 'A function', 'is_correct' => false],
                    ['text' => 'A variable', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'Which widget is used to create a scrollable list in Flutter?',
                'explanation' => 'ListView is the widget used to create scrollable lists in Flutter.',
                'answers' => [
                    ['text' => 'Column', 'is_correct' => false],
                    ['text' => 'Row', 'is_correct' => false],
                    ['text' => 'ListView', 'is_correct' => true],
                    ['text' => 'Container', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the main() function in Flutter?',
                'explanation' => 'The main() function is the entry point of a Flutter application.',
                'answers' => [
                    ['text' => 'A widget', 'is_correct' => false],
                    ['text' => 'The entry point of the app', 'is_correct' => true],
                    ['text' => 'A state management tool', 'is_correct' => false],
                    ['text' => 'A navigation method', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the difference between StatelessWidget and StatefulWidget?',
                'explanation' => 'StatelessWidget is immutable and cannot change, while StatefulWidget can change its state during its lifetime.',
                'answers' => [
                    ['text' => 'StatelessWidget can change, StatefulWidget cannot', 'is_correct' => false],
                    ['text' => 'StatefulWidget can change its state, StatelessWidget cannot', 'is_correct' => true],
                    ['text' => 'There is no difference', 'is_correct' => false],
                    ['text' => 'StatelessWidget is faster', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of setState() in Flutter?',
                'explanation' => 'setState() is used to notify Flutter that the state has changed and the widget needs to be rebuilt.',
                'answers' => [
                    ['text' => 'To create a new widget', 'is_correct' => false],
                    ['text' => 'To notify Flutter that state has changed', 'is_correct' => true],
                    ['text' => 'To navigate to a new screen', 'is_correct' => false],
                    ['text' => 'To delete a widget', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'Which widget is used for navigation in Flutter?',
                'explanation' => 'Navigator is the widget used for navigation between screens in Flutter.',
                'answers' => [
                    ['text' => 'Router', 'is_correct' => false],
                    ['text' => 'Navigator', 'is_correct' => true],
                    ['text' => 'Route', 'is_correct' => false],
                    ['text' => 'Screen', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is a Scaffold in Flutter?',
                'explanation' => 'Scaffold is a widget that provides a basic structure for a Flutter app screen, including app bar, body, and floating action button.',
                'answers' => [
                    ['text' => 'A database model', 'is_correct' => false],
                    ['text' => 'A basic structure for app screens', 'is_correct' => true],
                    ['text' => 'A state management tool', 'is_correct' => false],
                    ['text' => 'A navigation widget', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What does hot reload do in Flutter?',
                'explanation' => 'Hot reload allows you to see changes in your code immediately without restarting the app.',
                'answers' => [
                    ['text' => 'Restarts the app completely', 'is_correct' => false],
                    ['text' => 'Shows changes immediately without full restart', 'is_correct' => true],
                    ['text' => 'Deletes all data', 'is_correct' => false],
                    ['text' => 'Compiles the app', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the pubspec.yaml file used for?',
                'explanation' => 'pubspec.yaml is used to define project dependencies, assets, and configuration for a Flutter project.',
                'answers' => [
                    ['text' => 'To write Dart code', 'is_correct' => false],
                    ['text' => 'To define dependencies and project config', 'is_correct' => true],
                    ['text' => 'To create widgets', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'Which command is used to install Flutter packages?',
                'explanation' => 'flutter pub get is used to install packages defined in pubspec.yaml.',
                'answers' => [
                    ['text' => 'flutter install', 'is_correct' => false],
                    ['text' => 'flutter pub get', 'is_correct' => true],
                    ['text' => 'flutter get packages', 'is_correct' => false],
                    ['text' => 'flutter add', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Container widget?',
                'explanation' => 'Container is a versatile widget that can be used for padding, margins, decoration, and alignment.',
                'answers' => [
                    ['text' => 'To store data', 'is_correct' => false],
                    ['text' => 'For padding, margins, and decoration', 'is_correct' => true],
                    ['text' => 'To navigate between screens', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the difference between Column and Row widgets?',
                'explanation' => 'Column arranges children vertically, while Row arranges children horizontally.',
                'answers' => [
                    ['text' => 'Column is horizontal, Row is vertical', 'is_correct' => false],
                    ['text' => 'Column is vertical, Row is horizontal', 'is_correct' => true],
                    ['text' => 'There is no difference', 'is_correct' => false],
                    ['text' => 'Column is for text, Row is for images', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is a BuildContext in Flutter?',
                'explanation' => 'BuildContext is a handle to the location of a widget in the widget tree, used for navigation and accessing theme data.',
                'answers' => [
                    ['text' => 'A widget', 'is_correct' => false],
                    ['text' => 'A handle to widget location in the tree', 'is_correct' => true],
                    ['text' => 'A state management tool', 'is_correct' => false],
                    ['text' => 'A database connection', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Text widget?',
                'explanation' => 'The Text widget is used to display a string of text with a single style.',
                'answers' => [
                    ['text' => 'To create buttons', 'is_correct' => false],
                    ['text' => 'To display text', 'is_correct' => true],
                    ['text' => 'To manage state', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the AppBar widget used for?',
                'explanation' => 'AppBar is used to create a top app bar with title, actions, and navigation controls.',
                'answers' => [
                    ['text' => 'To create a bottom navigation', 'is_correct' => false],
                    ['text' => 'To create a top app bar', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the MaterialApp widget?',
                'explanation' => 'MaterialApp is the root widget that provides Material Design theming and navigation.',
                'answers' => [
                    ['text' => 'To create a single screen', 'is_correct' => false],
                    ['text' => 'To provide Material Design theming', 'is_correct' => true],
                    ['text' => 'To manage state', 'is_correct' => false],
                    ['text' => 'To store data', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the difference between EdgeInsets.all() and EdgeInsets.symmetric()?',
                'explanation' => 'EdgeInsets.all() applies the same padding to all sides, while EdgeInsets.symmetric() applies different padding to vertical and horizontal sides.',
                'answers' => [
                    ['text' => 'all() is for all sides, symmetric() is for vertical/horizontal', 'is_correct' => true],
                    ['text' => 'There is no difference', 'is_correct' => false],
                    ['text' => 'all() is for text, symmetric() is for images', 'is_correct' => false],
                    ['text' => 'all() is deprecated', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the FloatingActionButton widget?',
                'explanation' => 'FloatingActionButton is a circular button that floats above the content, typically used for primary actions.',
                'answers' => [
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'A floating button for primary actions', 'is_correct' => true],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the const keyword used for in Flutter?',
                'explanation' => 'const is used to create compile-time constants, which improves performance and reduces memory usage.',
                'answers' => [
                    ['text' => 'To make variables mutable', 'is_correct' => false],
                    ['text' => 'To create compile-time constants', 'is_correct' => true],
                    ['text' => 'To manage state', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the SizedBox widget?',
                'explanation' => 'SizedBox is used to create a box with a specific size, useful for spacing and sizing.',
                'answers' => [
                    ['text' => 'To create a sized box for spacing', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the difference between mainAxisAlignment and crossAxisAlignment?',
                'explanation' => 'mainAxisAlignment aligns children along the main axis, while crossAxisAlignment aligns along the cross axis.',
                'answers' => [
                    ['text' => 'mainAxis is main direction, crossAxis is perpendicular', 'is_correct' => true],
                    ['text' => 'There is no difference', 'is_correct' => false],
                    ['text' => 'mainAxis is for rows, crossAxis is for columns', 'is_correct' => false],
                    ['text' => 'mainAxis is deprecated', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the GestureDetector widget?',
                'explanation' => 'GestureDetector is used to detect gestures like taps, drags, and swipes.',
                'answers' => [
                    ['text' => 'To detect user gestures', 'is_correct' => true],
                    ['text' => 'To display images', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Image widget?',
                'explanation' => 'The Image widget is used to display images from various sources like network, assets, or memory.',
                'answers' => [
                    ['text' => 'To display images', 'is_correct' => true],
                    ['text' => 'To create buttons', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Expanded widget?',
                'explanation' => 'Expanded is used to make a child widget take up available space in a Row or Column.',
                'answers' => [
                    ['text' => 'To expand a widget to fill available space', 'is_correct' => true],
                    ['text' => 'To create a new screen', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Padding widget?',
                'explanation' => 'Padding is used to add space around a widget.',
                'answers' => [
                    ['text' => 'To add space around a widget', 'is_correct' => true],
                    ['text' => 'To create a border', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Center widget?',
                'explanation' => 'Center is used to center its child widget both horizontally and vertically.',
                'answers' => [
                    ['text' => 'To center a widget', 'is_correct' => true],
                    ['text' => 'To create a border', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the SafeArea widget?',
                'explanation' => 'SafeArea is used to ensure content is not obscured by system UI elements like notches or status bars.',
                'answers' => [
                    ['text' => 'To avoid system UI overlap', 'is_correct' => true],
                    ['text' => 'To create a border', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the InkWell widget?',
                'explanation' => 'InkWell is used to create a Material Design ripple effect when tapped.',
                'answers' => [
                    ['text' => 'To create a tap ripple effect', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                ],
            ],
        ];

        $this->createQuestions($beginnerQuiz, $beginnerQuestions);

        // Level 2: Intermediate Questions (30+)
        $intermediateQuiz = Quiz::create([
            'title' => 'Flutter Intermediate - State Management & Navigation',
            'description' => 'Test your knowledge of state management, navigation, forms, and intermediate Flutter concepts.',
            'book_id' => $flutterBook ? $flutterBook->id : null,
            'level' => 2,
            'is_active' => true,
            'created_by' => $admin->id,
        ]);

        $intermediateQuestions = [
            [
                'question' => 'What is the purpose of Provider in Flutter?',
                'explanation' => 'Provider is a state management solution that allows you to share data across widgets efficiently.',
                'answers' => [
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'For state management and data sharing', 'is_correct' => true],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To create widgets', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of Navigator.push()?',
                'explanation' => 'Navigator.push() is used to navigate to a new screen and add it to the navigation stack.',
                'answers' => [
                    ['text' => 'To go back', 'is_correct' => false],
                    ['text' => 'To navigate to a new screen', 'is_correct' => true],
                    ['text' => 'To delete a screen', 'is_correct' => false],
                    ['text' => 'To update state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of Navigator.pop()?',
                'explanation' => 'Navigator.pop() is used to go back to the previous screen in the navigation stack.',
                'answers' => [
                    ['text' => 'To navigate forward', 'is_correct' => false],
                    ['text' => 'To go back to previous screen', 'is_correct' => true],
                    ['text' => 'To delete a screen', 'is_correct' => false],
                    ['text' => 'To update state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Form widget?',
                'explanation' => 'Form is used to group and validate multiple form fields together.',
                'answers' => [
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To group and validate form fields', 'is_correct' => true],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of TextEditingController?',
                'explanation' => 'TextEditingController is used to control and read the value of a TextField.',
                'answers' => [
                    ['text' => 'To control TextField values', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of GlobalKey?',
                'explanation' => 'GlobalKey is used to uniquely identify widgets across the entire app, useful for Form validation.',
                'answers' => [
                    ['text' => 'To uniquely identify widgets globally', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of FutureBuilder?',
                'explanation' => 'FutureBuilder is used to build widgets based on the result of a Future.',
                'answers' => [
                    ['text' => 'To build widgets from Future results', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of StreamBuilder?',
                'explanation' => 'StreamBuilder is used to build widgets based on data from a Stream.',
                'answers' => [
                    ['text' => 'To build widgets from Stream data', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Hero widget?',
                'explanation' => 'Hero is used to create smooth transitions between screens for shared elements.',
                'answers' => [
                    ['text' => 'To create smooth screen transitions', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the AnimatedContainer widget?',
                'explanation' => 'AnimatedContainer automatically animates changes to its properties like size, color, and decoration.',
                'answers' => [
                    ['text' => 'To animate container property changes', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the ListView.builder?',
                'explanation' => 'ListView.builder creates a scrollable list efficiently by building items on demand.',
                'answers' => [
                    ['text' => 'To efficiently build lists on demand', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the RefreshIndicator widget?',
                'explanation' => 'RefreshIndicator is used to implement pull-to-refresh functionality.',
                'answers' => [
                    ['text' => 'To implement pull-to-refresh', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the WillPopScope widget?',
                'explanation' => 'WillPopScope is used to intercept back button presses and perform actions before popping.',
                'answers' => [
                    ['text' => 'To intercept back button presses', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the MediaQuery widget?',
                'explanation' => 'MediaQuery is used to access device information like screen size and orientation.',
                'answers' => [
                    ['text' => 'To access device screen information', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Theme widget?',
                'explanation' => 'Theme is used to access or override the current theme data.',
                'answers' => [
                    ['text' => 'To access or override theme data', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the InheritedWidget?',
                'explanation' => 'InheritedWidget is used to efficiently pass data down the widget tree to descendants.',
                'answers' => [
                    ['text' => 'To pass data down the widget tree', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the ValueNotifier?',
                'explanation' => 'ValueNotifier is used to hold a value and notify listeners when it changes.',
                'answers' => [
                    ['text' => 'To notify listeners of value changes', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the ChangeNotifier?',
                'explanation' => 'ChangeNotifier is a class that can be extended to notify listeners of changes.',
                'answers' => [
                    ['text' => 'To notify listeners of changes', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the TabController?',
                'explanation' => 'TabController is used to manage tab state and coordinate between TabBar and TabBarView.',
                'answers' => [
                    ['text' => 'To manage tab state', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the PageView widget?',
                'explanation' => 'PageView is used to create scrollable pages that can be swiped horizontally or vertically.',
                'answers' => [
                    ['text' => 'To create swipeable pages', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the BottomNavigationBar?',
                'explanation' => 'BottomNavigationBar is used to create a bottom navigation bar with multiple items.',
                'answers' => [
                    ['text' => 'To create bottom navigation', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Drawer widget?',
                'explanation' => 'Drawer is used to create a side navigation drawer that slides in from the side.',
                'answers' => [
                    ['text' => 'To create a side navigation drawer', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the SnackBar widget?',
                'explanation' => 'SnackBar is used to display brief messages at the bottom of the screen.',
                'answers' => [
                    ['text' => 'To display brief messages', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the AlertDialog widget?',
                'explanation' => 'AlertDialog is used to display important messages or confirmations to the user.',
                'answers' => [
                    ['text' => 'To display important messages', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the showDialog() function?',
                'explanation' => 'showDialog() is used to display a dialog overlay on the screen.',
                'answers' => [
                    ['text' => 'To display a dialog', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the showModalBottomSheet() function?',
                'explanation' => 'showModalBottomSheet() is used to display a modal bottom sheet.',
                'answers' => [
                    ['text' => 'To display a modal bottom sheet', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the showDatePicker() function?',
                'explanation' => 'showDatePicker() is used to display a date picker dialog.',
                'answers' => [
                    ['text' => 'To display a date picker', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the showTimePicker() function?',
                'explanation' => 'showTimePicker() is used to display a time picker dialog.',
                'answers' => [
                    ['text' => 'To display a time picker', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the showSearch() function?',
                'explanation' => 'showSearch() is used to display a search delegate interface.',
                'answers' => [
                    ['text' => 'To display a search interface', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the showCupertinoDialog() function?',
                'explanation' => 'showCupertinoDialog() is used to display iOS-style dialogs.',
                'answers' => [
                    ['text' => 'To display iOS-style dialogs', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
        ];

        $this->createQuestions($intermediateQuiz, $intermediateQuestions);

        // Level 3: Advanced Questions (30+)
        $advancedQuiz = Quiz::create([
            'title' => 'Flutter Advanced - Performance & Architecture',
            'description' => 'Test your knowledge of advanced Flutter concepts including performance optimization, architecture patterns, and complex state management.',
            'book_id' => $flutterBook ? $flutterBook->id : null,
            'level' => 3,
            'is_active' => true,
            'created_by' => $admin->id,
        ]);

        $advancedQuestions = [
            [
                'question' => 'What is the purpose of the const constructor?',
                'explanation' => 'const constructor creates compile-time constants, improving performance by reusing the same instance.',
                'answers' => [
                    ['text' => 'To create compile-time constants', 'is_correct' => true],
                    ['text' => 'To make variables mutable', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the RepaintBoundary widget?',
                'explanation' => 'RepaintBoundary is used to isolate repaints and improve performance by limiting the repaint area.',
                'answers' => [
                    ['text' => 'To isolate repaints and improve performance', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the AutomaticKeepAliveClientMixin?',
                'explanation' => 'AutomaticKeepAliveClientMixin is used to keep state alive when scrolling, preventing rebuilds.',
                'answers' => [
                    ['text' => 'To keep state alive during scrolling', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Sliver widgets?',
                'explanation' => 'Sliver widgets are used to create custom scrollable effects with fine-grained control.',
                'answers' => [
                    ['text' => 'To create custom scrollable effects', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the CustomPaint widget?',
                'explanation' => 'CustomPaint is used to create custom graphics and drawings using the Canvas API.',
                'answers' => [
                    ['text' => 'To create custom graphics and drawings', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the CustomScrollView widget?',
                'explanation' => 'CustomScrollView is used to create complex scrollable layouts with multiple slivers.',
                'answers' => [
                    ['text' => 'To create complex scrollable layouts', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the NotificationListener widget?',
                'explanation' => 'NotificationListener is used to listen to scroll notifications and other widget notifications.',
                'answers' => [
                    ['text' => 'To listen to widget notifications', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the LayoutBuilder widget?',
                'explanation' => 'LayoutBuilder is used to build widgets based on the parent widget\'s constraints.',
                'answers' => [
                    ['text' => 'To build widgets based on constraints', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Builder widget?',
                'explanation' => 'Builder is used to get a BuildContext at a specific location in the widget tree.',
                'answers' => [
                    ['text' => 'To get BuildContext at specific location', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the IgnorePointer widget?',
                'explanation' => 'IgnorePointer is used to prevent pointer events from reaching child widgets.',
                'answers' => [
                    ['text' => 'To ignore pointer events', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the AbsorbPointer widget?',
                'explanation' => 'AbsorbPointer is used to absorb pointer events, preventing them from reaching child widgets.',
                'answers' => [
                    ['text' => 'To absorb pointer events', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Transform widget?',
                'explanation' => 'Transform is used to apply transformations like rotation, scale, and translation to widgets.',
                'answers' => [
                    ['text' => 'To apply transformations to widgets', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the FadeTransition widget?',
                'explanation' => 'FadeTransition is used to animate the opacity of a widget.',
                'answers' => [
                    ['text' => 'To animate widget opacity', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the ScaleTransition widget?',
                'explanation' => 'ScaleTransition is used to animate the scale of a widget.',
                'answers' => [
                    ['text' => 'To animate widget scale', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the RotationTransition widget?',
                'explanation' => 'RotationTransition is used to animate the rotation of a widget.',
                'answers' => [
                    ['text' => 'To animate widget rotation', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the AnimationController?',
                'explanation' => 'AnimationController is used to control animations with start, stop, and reverse methods.',
                'answers' => [
                    ['text' => 'To control animations', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Tween class?',
                'explanation' => 'Tween is used to define the range of values for an animation.',
                'answers' => [
                    ['text' => 'To define animation value ranges', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the CurvedAnimation?',
                'explanation' => 'CurvedAnimation is used to apply curves to animations for easing effects.',
                'answers' => [
                    ['text' => 'To apply curves to animations', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the AnimatedBuilder?',
                'explanation' => 'AnimatedBuilder is used to rebuild widgets when animation values change.',
                'answers' => [
                    ['text' => 'To rebuild widgets on animation changes', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the PageStorage widget?',
                'explanation' => 'PageStorage is used to save and restore scroll positions and other state.',
                'answers' => [
                    ['text' => 'To save and restore scroll positions', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the KeepAlive widget?',
                'explanation' => 'KeepAlive is used to keep widget state alive when it would normally be disposed.',
                'answers' => [
                    ['text' => 'To keep widget state alive', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Visibility widget?',
                'explanation' => 'Visibility is used to show or hide widgets while maintaining their space in the layout.',
                'answers' => [
                    ['text' => 'To show or hide widgets', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Offstage widget?',
                'explanation' => 'Offstage is used to hide widgets from the visual tree while keeping them in the widget tree.',
                'answers' => [
                    ['text' => 'To hide widgets from visual tree', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the Opacity widget?',
                'explanation' => 'Opacity is used to make widgets semi-transparent.',
                'answers' => [
                    ['text' => 'To make widgets semi-transparent', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the ClipRRect widget?',
                'explanation' => 'ClipRRect is used to clip widgets with rounded corners.',
                'answers' => [
                    ['text' => 'To clip widgets with rounded corners', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the ClipOval widget?',
                'explanation' => 'ClipOval is used to clip widgets into an oval or circle shape.',
                'answers' => [
                    ['text' => 'To clip widgets into oval/circle', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the ClipPath widget?',
                'explanation' => 'ClipPath is used to clip widgets using a custom path.',
                'answers' => [
                    ['text' => 'To clip widgets with custom path', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the BackdropFilter widget?',
                'explanation' => 'BackdropFilter is used to apply image filters to the background behind a widget.',
                'answers' => [
                    ['text' => 'To apply filters to background', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the ShaderMask widget?',
                'explanation' => 'ShaderMask is used to apply shader effects to widgets.',
                'answers' => [
                    ['text' => 'To apply shader effects', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
            [
                'question' => 'What is the purpose of the ColorFiltered widget?',
                'explanation' => 'ColorFiltered is used to apply color filters to widgets.',
                'answers' => [
                    ['text' => 'To apply color filters', 'is_correct' => true],
                    ['text' => 'To display text', 'is_correct' => false],
                    ['text' => 'To navigate', 'is_correct' => false],
                    ['text' => 'To manage state', 'is_correct' => false],
                ],
            ],
        ];

        $this->createQuestions($advancedQuiz, $advancedQuestions);
    }

    /**
     * Helper method to create questions for a quiz.
     */
    private function createQuestions($quiz, $questions)
    {
        foreach ($questions as $index => $questionData) {
            $question = QuizQuestion::create([
                'quiz_id' => $quiz->id,
                'question' => $questionData['question'],
                'question_type' => 'multiple_choice',
                'explanation' => $questionData['explanation'] ?? null,
                'order' => $index + 1,
            ]);

            foreach ($questionData['answers'] as $answerIndex => $answerData) {
                QuizAnswer::create([
                    'question_id' => $question->id,
                    'answer_text' => $answerData['text'],
                    'is_correct' => $answerData['is_correct'],
                    'order' => $answerIndex + 1,
                ]);
            }
        }
    }
}

