<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Book;
use App\Models\BookChapter;
use Illuminate\Support\Facades\File;

class BookSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Create Flutter Book
        $book = Book::create([
            'title' => 'Mobile App Development with Flutter & Dart',
            'description' => 'A comprehensive guide to building mobile applications using Flutter and Dart. This book covers everything from the basics to advanced topics, taking you from zero to a publishable Flutter app.',
            'author' => 'Afrilen Technologies',
            'cover_image' => null,
            'folder_path' => 'Flutter Online Book Version',
            'total_chapters' => 25, // 24 chapters + introduction
            'is_active' => true,
            'order' => 1,
        ]);

        // Define chapters (including introduction)
        $chapters = [
            ['number' => 0, 'title' => 'Introduction and Course Overview', 'file' => 'introduction.html', 'description' => 'Welcome to the Flutter & Dart course. Learn about the course structure, objectives, and what you\'ll build.'],
            ['number' => 1, 'title' => 'Introduction to Mobile App Development', 'file' => 'chapter-1.html', 'description' => 'Understand the mobile development landscape and where Flutter fits in.'],
            ['number' => 2, 'title' => 'Getting Started with Flutter and Dart', 'file' => 'chapter-2.html', 'description' => 'Set up your development environment and create your first Flutter app.'],
            ['number' => 3, 'title' => 'Dart Language Fundamentals', 'file' => 'chapter-3.html', 'description' => 'Master the Dart programming language basics.'],
            ['number' => 4, 'title' => 'Flutter Widgets and Architecture', 'file' => 'chapter-4.html', 'description' => 'Learn about Flutter\'s widget system and app architecture.'],
            ['number' => 5, 'title' => 'Project Setup and Tooling', 'file' => 'chapter-5.html', 'description' => 'Set up projects and use Flutter development tools effectively.'],
            ['number' => 6, 'title' => 'State Management Basics', 'file' => 'chapter-6.html', 'description' => 'Understand state management with setState and basic patterns.'],
            ['number' => 7, 'title' => 'Asynchronous Programming', 'file' => 'chapter-7.html', 'description' => 'Work with Futures, Streams, and Isolates in Dart.'],
            ['number' => 8, 'title' => 'Networking and REST APIs', 'file' => 'chapter-8.html', 'description' => 'Connect your app to backend services and APIs.'],
            ['number' => 9, 'title' => 'Layout Deep Dive', 'file' => 'chapter-9.html', 'description' => 'Master advanced widgets, constraints, and responsive design.'],
            ['number' => 10, 'title' => 'Theming, Styling, and Custom Widgets', 'file' => 'chapter-10.html', 'description' => 'Create beautiful UIs with theming and custom widgets.'],
            ['number' => 11, 'title' => 'Navigation, Routing, and Deep Linking', 'file' => 'chapter-11.html', 'description' => 'Implement navigation and handle deep links in your app.'],
            ['number' => 12, 'title' => 'Forms, Input Handling, and Validation', 'file' => 'chapter-12.html', 'description' => 'Build forms and handle user input with validation.'],
            ['number' => 13, 'title' => 'Advanced State Management', 'file' => 'chapter-13.html', 'description' => 'Learn Provider and scalable state management patterns.'],
            ['number' => 14, 'title' => 'Lists, Grids, and Dynamic Collections', 'file' => 'chapter-14.html', 'description' => 'Display and manage lists and grids efficiently.'],
            ['number' => 15, 'title' => 'Mini Project: Course Catalog App', 'file' => 'chapter-15.html', 'description' => 'Build your first mini project - a course catalog app.'],
            ['number' => 16, 'title' => 'Testing and CI/CD', 'file' => 'chapter-16.html', 'description' => 'Write tests and set up continuous integration.'],
            ['number' => 17, 'title' => 'Performance and Profiling', 'file' => 'chapter-17.html', 'description' => 'Optimize your app\'s performance and use profiling tools.'],
            ['number' => 18, 'title' => 'Security and Data Storage', 'file' => 'chapter-18.html', 'description' => 'Implement security best practices and data storage.'],
            ['number' => 19, 'title' => 'Accessibility and Internationalization', 'file' => 'chapter-19.html', 'description' => 'Make your app accessible and support multiple languages.'],
            ['number' => 20, 'title' => 'Firebase Integration for Flutter', 'file' => 'chapter-20.html', 'description' => 'Integrate Firebase services into your Flutter app.'],
            ['number' => 21, 'title' => 'Publishing and Release Management', 'file' => 'chapter-21.html', 'description' => 'Prepare and publish your app to app stores.'],
            ['number' => 22, 'title' => 'Advanced Topics', 'file' => 'chapter-22.html', 'description' => 'Explore advanced Flutter concepts and techniques.'],
            ['number' => 23, 'title' => 'Advanced Topics Continued', 'file' => 'chapter-23.html', 'description' => 'Continue exploring advanced Flutter topics.'],
            ['number' => 24, 'title' => 'Final Project and Next Steps', 'file' => 'chapter-24.html', 'description' => 'Complete your final project and plan your next steps.'],
        ];

        // Create chapters
        foreach ($chapters as $index => $chapterData) {
            $filePath = public_path($book->folder_path . '/' . $chapterData['file']);
            
            // Only create chapter if file exists
            if (File::exists($filePath)) {
                BookChapter::create([
                    'book_id' => $book->id,
                    'title' => $chapterData['title'],
                    'file_name' => $chapterData['file'],
                    'chapter_number' => $chapterData['number'],
                    'description' => $chapterData['description'],
                    'order' => $index,
                ]);
            }
        }

        // Update book total chapters count
        $book->update([
            'total_chapters' => BookChapter::where('book_id', $book->id)->count()
        ]);

        $this->command->info('Book and chapters created successfully!');
    }
}
