<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AdminSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Check if admin already exists
        $adminExists = User::where('email', 'admin@afrilen.com')->where('role', 'admin')->exists();
        
        if (!$adminExists) {
            // Generate a secure random password
            $password = bin2hex(random_bytes(16)); // 32 character random password
            
            User::create([
                'name' => 'Admin User',
                'email' => 'admin@afrilen.com',
                'password' => Hash::make($password),
                'role' => 'admin',
                'email_verified_at' => now(),
            ]);
            
            $this->command->info('Admin user created successfully!');
            $this->command->info('Email: admin@afrilen.com');
            $this->command->warn('SECURITY: Password has been generated. Please change it immediately after first login!');
            $this->command->info('Temporary Password: ' . $password);
            $this->command->warn('IMPORTANT: Save this password securely and change it after first login!');
        } else {
            $this->command->info('Admin user already exists!');
        }
    }
}

