<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class FixProfilePictureColumnToLongtext extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Change profile_picture column to LONGTEXT to accommodate encrypted base64 data URIs
        DB::statement('ALTER TABLE `users` MODIFY `profile_picture` LONGTEXT NULL');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Revert back to VARCHAR(255)
        DB::statement('ALTER TABLE `users` MODIFY `profile_picture` VARCHAR(255) NULL');
    }
}

