<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBookChapterPracticesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('book_chapter_practices', function (Blueprint $table) {
            $table->id();
            $table->foreignId('book_chapter_id')->constrained()->onDelete('cascade');
            $table->string('title');
            $table->text('description')->nullable();
            $table->text('dart_code')->nullable(); // Pre-filled Dart code for the practice
            $table->text('flutter_code')->nullable(); // Pre-filled Flutter code for the practice
            $table->enum('type', ['dart', 'flutter'])->default('dart'); // Practice type
            $table->text('instructions')->nullable(); // Instructions for the practice
            $table->integer('order')->default(0); // Order of practice within chapter
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('book_chapter_practices');
    }
}
