<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBookProgressTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('book_progress', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->foreignId('book_id')->constrained()->onDelete('cascade');
            $table->foreignId('book_chapter_id')->nullable()->constrained()->onDelete('cascade');
            $table->integer('last_page_position')->default(0)->comment('Last scroll position');
            $table->boolean('is_completed')->default(false);
            $table->timestamp('last_read_at')->nullable();
            $table->timestamps();
            
            $table->unique(['user_id', 'book_id', 'book_chapter_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('book_progress');
    }
}
