<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDeliveryFieldsToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            // T-Shirt size (selected by student)
            $table->enum('t_shirt_size', ['XS', 'S', 'M', 'L', 'XL', 'XXL', 'XXXL'])->nullable()->after('address');
            
            // Delivery address (updated by student)
            $table->text('delivery_address')->nullable()->after('t_shirt_size');
            
            // Delivery statuses (updated by admin)
            $table->enum('t_shirt_status', ['pending', 'on_the_way', 'delivered', 'canceled', 'returned'])->default('pending')->after('delivery_address');
            $table->enum('cap_status', ['pending', 'on_the_way', 'delivered', 'canceled', 'returned'])->default('pending')->after('t_shirt_status');
            $table->enum('id_card_status', ['pending', 'on_the_way', 'delivered', 'canceled', 'returned'])->default('pending')->after('cap_status');
            $table->enum('handout_book_status', ['pending', 'on_the_way', 'delivered', 'canceled', 'returned'])->default('pending')->after('id_card_status');
            
            // Timestamps for delivery updates
            $table->timestamp('t_shirt_updated_at')->nullable()->after('handout_book_status');
            $table->timestamp('cap_updated_at')->nullable()->after('t_shirt_updated_at');
            $table->timestamp('id_card_updated_at')->nullable()->after('cap_updated_at');
            $table->timestamp('handout_book_updated_at')->nullable()->after('id_card_updated_at');
            
            // Admin notes for each item
            $table->text('t_shirt_notes')->nullable()->after('handout_book_updated_at');
            $table->text('cap_notes')->nullable()->after('t_shirt_notes');
            $table->text('id_card_notes')->nullable()->after('cap_notes');
            $table->text('handout_book_notes')->nullable()->after('id_card_notes');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                't_shirt_size',
                'delivery_address',
                't_shirt_status',
                'cap_status',
                'id_card_status',
                'handout_book_status',
                't_shirt_updated_at',
                'cap_updated_at',
                'id_card_updated_at',
                'handout_book_updated_at',
                't_shirt_notes',
                'cap_notes',
                'id_card_notes',
                'handout_book_notes',
            ]);
        });
    }
}

