<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('string')->comment('string, boolean, integer, json');
            $table->string('group')->default('general')->comment('general, email, system');
            $table->text('description')->nullable();
            $table->timestamps();
            
            $table->index('key');
            $table->index('group');
        });
        
        // Insert default settings
        DB::table('settings')->insert([
            // System Settings
            ['key' => 'system_name', 'value' => 'Afrilen Technologies', 'type' => 'string', 'group' => 'general', 'description' => 'The name of the application/system', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'system_description', 'value' => 'Learning Management System', 'type' => 'string', 'group' => 'general', 'description' => 'Brief description of the system', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'system_email', 'value' => 'noreply@afrilen.com', 'type' => 'string', 'group' => 'general', 'description' => 'Default system email address', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'system_phone', 'value' => '', 'type' => 'string', 'group' => 'general', 'description' => 'System contact phone number', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'system_address', 'value' => '', 'type' => 'string', 'group' => 'general', 'description' => 'System physical address', 'created_at' => now(), 'updated_at' => now()],
            
            // Email/SMTP Settings
            ['key' => 'mail_mailer', 'value' => 'smtp', 'type' => 'string', 'group' => 'email', 'description' => 'Mail driver (smtp, mailgun, ses, etc.)', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'mail_host', 'value' => '', 'type' => 'string', 'group' => 'email', 'description' => 'SMTP host', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'mail_port', 'value' => '587', 'type' => 'string', 'group' => 'email', 'description' => 'SMTP port', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'mail_username', 'value' => '', 'type' => 'string', 'group' => 'email', 'description' => 'SMTP username', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'mail_password', 'value' => '', 'type' => 'string', 'group' => 'email', 'description' => 'SMTP password (encrypted)', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'mail_encryption', 'value' => 'tls', 'type' => 'string', 'group' => 'email', 'description' => 'SMTP encryption (tls, ssl, null)', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'mail_from_address', 'value' => 'noreply@afrilen.com', 'type' => 'string', 'group' => 'email', 'description' => 'Email from address', 'created_at' => now(), 'updated_at' => now()],
            ['key' => 'mail_from_name', 'value' => 'Afrilen Technologies', 'type' => 'string', 'group' => 'email', 'description' => 'Email from name', 'created_at' => now(), 'updated_at' => now()],
        ]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('settings');
    }
}

