<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAssignmentSubmissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('assignment_submissions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('assignment_id')->constrained('assignments')->onDelete('cascade');
            $table->foreignId('student_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('course_id')->constrained('courses')->onDelete('cascade');
            $table->text('submission_text')->nullable();
            $table->string('submission_file')->nullable()->comment('Path to uploaded file');
            $table->timestamp('submitted_at')->nullable();
            $table->boolean('is_late')->default(false);
            $table->enum('status', ['draft', 'submitted', 'graded', 'returned'])->default('draft');
            $table->decimal('score', 5, 2)->nullable()->comment('Points awarded');
            $table->decimal('grade_percentage', 5, 2)->nullable();
            $table->text('instructor_feedback')->nullable();
            $table->timestamp('graded_at')->nullable();
            $table->foreignId('graded_by')->nullable()->constrained('users')->onDelete('set null');
            $table->timestamps();
            
            // Indexes
            $table->index('assignment_id');
            $table->index('student_id');
            $table->index(['assignment_id', 'student_id'])->unique();
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('assignment_submissions');
    }
}

