<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAssignmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('assignments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('course_id')->constrained('courses')->onDelete('cascade');
            $table->foreignId('chapter_id')->nullable()->constrained('course_chapters')->onDelete('set null');
            $table->string('title');
            $table->text('description')->nullable();
            $table->text('instructions')->nullable();
            $table->date('due_date');
            $table->time('due_time')->nullable();
            $table->decimal('total_points', 5, 2)->default(100.00);
            $table->boolean('allow_late_submission')->default(true);
            $table->integer('late_penalty_percentage')->default(10)->comment('Percentage penalty per day');
            $table->boolean('is_published')->default(false);
            $table->timestamps();
            
            // Indexes
            $table->index('course_id');
            $table->index(['course_id', 'is_published']);
            $table->index('due_date');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('assignments');
    }
}

