<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClassSessionVideosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('class_session_videos', function (Blueprint $table) {
            $table->id();
            $table->foreignId('course_id')->constrained('courses')->onDelete('cascade');
            $table->foreignId('instructor_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('course_offering_id')->nullable()->constrained('course_offerings')->onDelete('set null');
            $table->string('title');
            $table->text('description')->nullable();
            $table->date('session_date');
            $table->text('mega_storage_link')->nullable();
            $table->text('download_key')->nullable();
            $table->time('video_duration')->nullable();
            $table->string('thumbnail_url')->nullable();
            $table->boolean('is_published')->default(false);
            $table->integer('views_count')->default(0);
            $table->timestamps();
            
            // Indexes
            $table->index('course_id');
            $table->index('instructor_id');
            $table->index('course_offering_id');
            $table->index('is_published');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('class_session_videos');
    }
}

