<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateCourseScheduleFields extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->string('from_month')->nullable()->after('session_period');
            $table->string('to_month')->nullable()->after('from_month');
            $table->json('schedule_days')->nullable()->comment('Array of days like ["Monday", "Wednesday"]')->after('schedule_info');
            $table->time('start_time')->nullable()->after('schedule_days');
            $table->time('end_time')->nullable()->after('start_time');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->dropColumn(['from_month', 'to_month', 'schedule_days', 'start_time', 'end_time']);
        });
    }
}

