<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSessionInfoToCoursesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->string('academic_session')->nullable()->after('description');
            $table->string('session_period')->nullable()->comment('e.g., Jan-March')->after('academic_session');
            $table->integer('number_of_sessions')->default(0)->after('session_period');
            $table->integer('number_of_weeks')->default(0)->after('number_of_sessions');
            $table->text('schedule_info')->nullable()->comment('e.g., Tuesdays & Thursdays, 5:00 – 6:30 PM')->after('number_of_weeks');
            $table->integer('session_duration_minutes')->default(90)->comment('Session length in minutes')->after('schedule_info');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('courses', function (Blueprint $table) {
            $table->dropColumn([
                'academic_session',
                'session_period',
                'number_of_sessions',
                'number_of_weeks',
                'schedule_info',
                'session_duration_minutes',
            ]);
        });
    }
}


