<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Cross-Origin Resource Sharing (CORS) Configuration
    |--------------------------------------------------------------------------
    |
    | Here you may configure your settings for cross-origin resource sharing
    | or "CORS". This determines what cross-origin operations may execute
    | in web browsers. You are free to adjust these settings as needed.
    |
    | To learn more: https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS
    |
    */

    'paths' => ['api/*'],

    'allowed_methods' => ['GET', 'POST', 'PUT', 'PATCH', 'DELETE', 'OPTIONS'],

    // Restrict origins in production - set CORS_ALLOWED_ORIGINS in .env (comma-separated)
    // For development, you can use '*' but production should specify exact domains
    'allowed_origins' => env('CORS_ALLOWED_ORIGINS') 
        ? array_map('trim', explode(',', env('CORS_ALLOWED_ORIGINS'))) 
        : (env('APP_ENV') === 'production' ? [] : ['*']),

    'allowed_origins_patterns' => [],

    'allowed_headers' => ['Content-Type', 'X-Requested-With', 'Authorization', 'Accept', 'X-XSRF-TOKEN'],

    'exposed_headers' => ['Authorization'],

    'max_age' => 86400, // 24 hours

    // For mobile apps using token authentication, credentials might not be needed
    'supports_credentials' => false,

];
