<?php

/**
 * Quick script to check if delivery fields migration has been run
 * Run this on the live server: php check_migration_status.php
 */

require __DIR__ . '/vendor/autoload.php';

$app = require_once __DIR__ . '/bootstrap/app.php';
$app->make(\Illuminate\Contracts\Console\Kernel::class)->bootstrap();

use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

echo "Checking delivery fields migration status...\n\n";

$columns = [
    't_shirt_size',
    'delivery_address',
    't_shirt_status',
    'cap_status',
    'id_card_status',
    'handout_book_status',
];

$missingColumns = [];
$existingColumns = [];

foreach ($columns as $column) {
    if (Schema::hasColumn('users', $column)) {
        $existingColumns[] = $column;
        echo "✓ Column '{$column}' exists\n";
    } else {
        $missingColumns[] = $column;
        echo "✗ Column '{$column}' MISSING\n";
    }
}

echo "\n";

if (empty($missingColumns)) {
    echo "✅ All delivery fields exist in the database!\n";
} else {
    echo "❌ Missing columns: " . implode(', ', $missingColumns) . "\n";
    echo "\nYou need to run the migration:\n";
    echo "php artisan migrate\n";
}

