<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Notification;
use App\Observers\NotificationObserver;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Add installation check middleware to web routes
        $this->app['router']->pushMiddlewareToGroup('web', \App\Http\Middleware\CheckInstallation::class);
        
        // Register view composer for student balance
        view()->composer('layouts.student', \App\Http\ViewComposers\StudentBalanceComposer::class);
        
        // Register notification observer for push notifications
        Notification::observe(NotificationObserver::class);
    }
}
