<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeePayment extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'student_id',
        'admin_id',
        'course_id',
        'course_offering_id',
        'amount',
        'payment_date',
        'payment_method',
        'payment_status',
        'transaction_reference',
        'notes',
        'recorded_by',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'amount' => 'decimal:2',
        'payment_date' => 'date',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    /**
     * Get the student for this payment.
     */
    public function student()
    {
        return $this->belongsTo(User::class, 'student_id');
    }

    /**
     * Get the admin for this payment (if admin payment).
     */
    public function admin()
    {
        return $this->belongsTo(User::class, 'admin_id');
    }

    /**
     * Get the course for this payment.
     */
    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }

    /**
     * Get the course offering for this payment.
     */
    public function courseOffering()
    {
        return $this->belongsTo(CourseOffering::class, 'course_offering_id');
    }

    /**
     * Get the admin who recorded this payment.
     */
    public function recordedBy()
    {
        return $this->belongsTo(User::class, 'recorded_by');
    }

    /**
     * Check if payment counts toward actual money at hand.
     */
    public function countsTowardActualMoney()
    {
        return $this->payment_status === 'regular';
    }

    /**
     * Check if payment is a scholarship.
     */
    public function isScholarship()
    {
        return $this->payment_status === 'scholarship';
    }

    /**
     * Check if payment is refunded.
     */
    public function isRefunded()
    {
        return $this->payment_status === 'refunded';
    }
}

