<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CourseChapter extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'course_id',
        'chapter_number',
        'title',
        'description',
        'content',
        'session_number',
        'order',
        'is_published',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'is_published' => 'boolean',
    ];

    /**
     * Get the course that owns this chapter.
     */
    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }

    /**
     * Get the progress records for this chapter.
     */
    public function progress()
    {
        return $this->hasMany(ChapterProgress::class, 'chapter_id');
    }

    /**
     * Get the assignments for this chapter.
     */
    public function assignments()
    {
        return $this->hasMany(Assignment::class, 'chapter_id');
    }
}


