<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Certificate extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'student_id',
        'course_id',
        'course_offering_id',
        'title',
        'certificate_type',
        'file_path',
        'file_name',
        'file_size',
        'issued_date',
        'issued_by',
        'description',
        'is_active',
        'download_count',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'issued_date' => 'date',
        'is_active' => 'boolean',
    ];

    /**
     * Get the student that owns this certificate.
     */
    public function student()
    {
        return $this->belongsTo(User::class, 'student_id');
    }

    /**
     * Get the course for this certificate.
     */
    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id');
    }

    /**
     * Get the course offering for this certificate.
     */
    public function courseOffering()
    {
        return $this->belongsTo(CourseOffering::class, 'course_offering_id');
    }

    /**
     * Get the admin who issued this certificate.
     */
    public function issuedBy()
    {
        return $this->belongsTo(User::class, 'issued_by');
    }
}

