<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookChapterPractice extends Model
{
    use HasFactory;

    protected $fillable = [
        'book_chapter_id',
        'title',
        'description',
        'dart_code',
        'flutter_code',
        'type',
        'instructions',
        'order',
        'is_active',
    ];

    protected $casts = [
        'order' => 'integer',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function chapter()
    {
        return $this->belongsTo(BookChapter::class, 'book_chapter_id');
    }
}
