<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Book extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'author',
        'cover_image',
        'folder_path',
        'total_chapters',
        'is_active',
        'order',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'total_chapters' => 'integer',
        'order' => 'integer',
    ];

    // Relationships
    public function chapters()
    {
        return $this->hasMany(BookChapter::class)->orderBy('order');
    }

    public function notes()
    {
        return $this->hasMany(BookNote::class);
    }

    public function progress()
    {
        return $this->hasMany(BookProgress::class);
    }

    public function bookmarks()
    {
        return $this->hasMany(Bookmark::class);
    }

    // Helper methods
    public function getUserProgress($userId)
    {
        return $this->progress()->where('user_id', $userId)->first();
    }

    public function getUserNotes($userId)
    {
        return $this->notes()->where('user_id', $userId)->get();
    }

    public function getUserBookmarks($userId)
    {
        return $this->bookmarks()->where('user_id', $userId)->get();
    }
}
