<?php

namespace App\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class StudentWelcomeMail extends Mailable
{
    use Queueable, SerializesModels;

    public $student;
    public $password;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $student, $password)
    {
        $this->student = $student;
        $this->password = $password;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $systemName = \App\Models\Setting::get('system_name') ?? config('app.name');
        
        return $this->subject('Welcome to ' . $systemName)
                    ->view('emails.student-welcome')
                    ->with([
                        'student' => $this->student,
                        'password' => $this->password,
                        'systemName' => $systemName,
                    ]);
    }
}

