<?php

namespace App\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class PaymentNotificationMail extends Mailable
{
    use Queueable, SerializesModels;

    public $student;
    public $transactionId;
    public $amount;
    public $paymentMethod;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $student, $transactionId, $amount, $paymentMethod = null)
    {
        $this->student = $student;
        $this->transactionId = $transactionId;
        $this->amount = $amount;
        $this->paymentMethod = $paymentMethod;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $systemName = \App\Models\Setting::get('system_name') ?? config('app.name');
        
        return $this->subject('Payment Notification - ' . $this->student->name)
                    ->view('emails.payment-notification')
                    ->with([
                        'student' => $this->student,
                        'transactionId' => $this->transactionId,
                        'amount' => $this->amount,
                        'paymentMethod' => $this->paymentMethod,
                        'systemName' => $systemName,
                    ]);
    }
}

