<?php

namespace App\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class InstructorWelcomeMail extends Mailable
{
    use Queueable, SerializesModels;

    public $instructor;
    public $password;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $instructor, $password)
    {
        $this->instructor = $instructor;
        $this->password = $password;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $systemName = \App\Models\Setting::get('system_name') ?? config('app.name');
        
        return $this->subject('Welcome to ' . $systemName)
                    ->view('emails.instructor-welcome')
                    ->with([
                        'instructor' => $this->instructor,
                        'password' => $this->password,
                        'systemName' => $systemName,
                    ]);
    }
}

