<?php

namespace App\Http\Resources\Api\V1;

use Illuminate\Http\Resources\Json\JsonResource;

class BookResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'title' => $this->title,
            'author' => $this->author,
            'description' => $this->description,
            'level' => $this->level,
            'thumbnail' => $this->thumbnail,
            'total_chapters' => $this->when(isset($this->chapters_count), $this->chapters_count),
            'read_chapters' => $this->when(isset($this->read_chapters), $this->read_chapters),
            'progress' => $this->when(isset($this->progress), round($this->progress, 2)),
            'chapters' => $this->when($this->relationLoaded('chapters'), ChapterResource::collection($this->chapters)),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
