<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class SecurityHeaders
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);

        // Security headers
        $response->headers->set('X-Content-Type-Options', 'nosniff');
        $response->headers->set('X-Frame-Options', 'SAMEORIGIN');
        $response->headers->set('X-XSS-Protection', '1; mode=block');
        $response->headers->set('Referrer-Policy', 'strict-origin-when-cross-origin');
        
        // Content Security Policy - Allow CDN resources for FontAwesome, Tawk.to, and other external libraries
        $csp = "default-src 'self'; " .
               "script-src 'self' 'unsafe-inline' 'unsafe-eval' https://cdn.jsdelivr.net https://cdnjs.cloudflare.com https://*.cloudflare.com https://dartpad.dev https://embed.tawk.to https://*.tawk.to; " .
               "style-src 'self' 'unsafe-inline' https://cdn.jsdelivr.net https://cdnjs.cloudflare.com https://*.cloudflare.com https://fonts.bunny.net https://fonts.googleapis.com; " .
               "img-src 'self' data: https: blob:; " .
               "font-src 'self' data: https://cdn.jsdelivr.net https://cdnjs.cloudflare.com https://*.cloudflare.com https://fonts.bunny.net https://fonts.gstatic.com https://fonts.googleapis.com; " .
               "connect-src 'self' https://dartpad.dev https://embed.tawk.to https://*.tawk.to https://cdnjs.cloudflare.com; " .
               "frame-src 'self' https://dartpad.dev https://embed.tawk.to https://*.tawk.to; " .
               "object-src 'none'; " .
               "base-uri 'self'; " .
               "form-action 'self';";
        
        $response->headers->set('Content-Security-Policy', $csp);
        
        // Remove server information
        $response->headers->remove('Server');
        $response->headers->remove('X-Powered-By');

        return $response;
    }
}

