<?php

namespace App\Http\Controllers\Student;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Certificate;
use App\Models\Enrollment;

class CertificateController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware(['auth', 'role:student']);
    }

    /**
     * Display a listing of certificates for the student.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $student = Auth::user();
        
        $certificates = Certificate::where('student_id', $student->id)
            ->where('is_active', true)
            ->with(['course', 'courseOffering'])
            ->orderBy('issued_date', 'desc')
            ->get();
        
        return view('student.certificates.index', compact('certificates'));
    }

    /**
     * Display the specified certificate.
     *
     * @param  int  $id
     * @return \Illuminate\View\View
     */
    public function show($id)
    {
        $student = Auth::user();
        
        $certificate = Certificate::where('id', $id)
            ->where('student_id', $student->id)
            ->where('is_active', true)
            ->with(['course', 'courseOffering'])
            ->firstOrFail();
        
        return view('student.certificates.show', compact('certificate'));
    }
}

