<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Quiz;

class ActivateAllQuizzes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'quizzes:activate-all';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Activate all quizzes in the database';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $count = Quiz::where('is_active', false)
            ->orWhereNull('is_active')
            ->update(['is_active' => true]);

        $this->info("Activated {$count} quiz(es).");
        
        $total = Quiz::count();
        $active = Quiz::where('is_active', true)->count();
        
        $this->info("Total quizzes: {$total}, Active: {$active}");
        
        return 0;
    }
}

