# Afrilen Portal - Laravel Learning Management System

A comprehensive Learning Management System (LMS) built with Laravel 8, designed for educational institutions to manage courses, students, instructors, assignments, quizzes, and certifications.

## Features

- **Multi-role System**: Admin, Instructor, and Student roles with role-based access control
- **Course Management**: Create and manage courses with chapters and offerings
- **Student Enrollment**: Track student enrollments and progress
- **Assignment System**: Create assignments, submit work, and grade submissions
- **Quiz System**: Comprehensive quiz management with analytics and bookmarks
- **Book Reader**: Interactive book reading with notes, bookmarks, and progress tracking
- **Certificate Generation**: Generate and manage course completion certificates
- **Payment Tracking**: Track fee payments and student finances
- **Notifications**: Real-time notification system
- **RESTful API**: Complete API v1 for mobile and third-party integrations

## Requirements

- PHP >= 8.1
- Composer
- MySQL >= 5.7 or MariaDB >= 10.3
- Redis (recommended for production)
- Node.js & NPM (for frontend assets)

## Installation

### 1. Clone the Repository

```bash
git clone <repository-url>
cd afrilen_laravel_portal
```

### 2. Install Dependencies

```bash
composer install
npm install
```

### 3. Environment Configuration

Copy the `.env.example` file to `.env`:

```bash
cp .env.example .env
```

Generate application key:

```bash
php artisan key:generate
```

### 4. Configure Environment Variables

Edit `.env` file with your configuration:

```env
APP_NAME="Afrilen Portal"
APP_ENV=production
APP_DEBUG=false
APP_URL=https://your-domain.com

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=afrilen_portal
DB_USERNAME=your_username
DB_PASSWORD=your_password

# Redis Configuration (recommended for production)
REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379

# Cache and Session (use Redis in production)
CACHE_DRIVER=redis
SESSION_DRIVER=redis
QUEUE_CONNECTION=redis

# Mail Configuration
MAIL_MAILER=smtp
MAIL_HOST=your_smtp_host
MAIL_PORT=587
MAIL_USERNAME=your_email
MAIL_PASSWORD=your_password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS="noreply@your-domain.com"
MAIL_FROM_NAME="${APP_NAME}"

# CORS Configuration (comma-separated domains)
CORS_ALLOWED_ORIGINS=https://your-domain.com,https://www.your-domain.com

# Session Security (set to true in production with HTTPS)
SESSION_SECURE_COOKIE=true
```

### 5. Run Migrations

```bash
php artisan migrate
```

### 6. Seed Database (Optional)

Create admin user:

```bash
php artisan db:seed --class=AdminSeeder
```

**Important**: The seeder will generate a random password. Save it securely and change it after first login!

### 7. Build Frontend Assets

For development:
```bash
npm run dev
```

For production:
```bash
npm run production
```

### 8. Set Storage Link

```bash
php artisan storage:link
```

### 9. Optimize for Production

```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

## Production Deployment Checklist

- [ ] Set `APP_ENV=production` in `.env`
- [ ] Set `APP_DEBUG=false` in `.env`
- [ ] Set `SESSION_SECURE_COOKIE=true` in `.env` (if using HTTPS)
- [ ] Configure `CORS_ALLOWED_ORIGINS` with your production domains
- [ ] Use Redis for cache, session, and queue drivers
- [ ] Set `LOG_LEVEL=error` in `.env`
- [ ] Configure proper mail settings
- [ ] Set up SSL/TLS certificate
- [ ] Configure web server (Nginx/Apache)
- [ ] Set up queue worker: `php artisan queue:work`
- [ ] Set up scheduled tasks in cron: `* * * * * cd /path-to-your-project && php artisan schedule:run >> /dev/null 2>&1`
- [ ] Set proper file permissions (storage and bootstrap/cache should be writable)
- [ ] Remove or secure `sync_config.jsonc` file (contains FTP credentials)
- [ ] Review and update default admin password after first login

## Security Considerations

1. **Never commit `.env` file** - It contains sensitive credentials
2. **Remove hardcoded credentials** - Check `sync_config.jsonc` and remove any passwords
3. **Setup routes are disabled in production** - Only accessible in local/staging environments
4. **CORS is restricted** - Configure `CORS_ALLOWED_ORIGINS` for your domains
5. **Rate limiting** - API endpoints have rate limiting enabled
6. **CSRF protection** - Enabled for all web routes
7. **Password hashing** - Uses Laravel's secure password hashing
8. **SQL injection protection** - Uses Eloquent ORM with parameter binding

## API Documentation

The API is available at `/api/v1/`. See the Postman collection in `postman/` directory for complete API documentation and test cases.

### Authentication

All API endpoints (except login and password reset) require authentication via Laravel Sanctum tokens.

```bash
POST /api/v1/auth/login
Content-Type: application/json

{
    "login": "student_id_or_email",
    "password": "password",
    "role": "student|instructor|admin",
    "remember_me": false
}
```

## File Structure

```
app/
├── Http/
│   ├── Controllers/
│   │   ├── Admin/          # Admin controllers
│   │   ├── Api/V1/         # API v1 controllers
│   │   ├── Instructor/     # Instructor controllers
│   │   └── Student/        # Student controllers
│   └── Middleware/         # Custom middleware
├── Models/                 # Eloquent models
└── Mail/                   # Mail classes

config/                     # Configuration files
database/
├── migrations/             # Database migrations
└── seeders/                # Database seeders

routes/
├── api.php                 # API routes
├── api/v1.php             # API v1 routes
└── web.php                 # Web routes

resources/
├── views/                  # Blade templates
├── css/                    # Stylesheets
└── js/                     # JavaScript files
```

## Queue Workers

For production, run queue workers to process background jobs:

```bash
php artisan queue:work --tries=3
```

Or use a process manager like Supervisor to keep it running.

## Scheduled Tasks

Add to your crontab:

```bash
* * * * * cd /path-to-your-project && php artisan schedule:run >> /dev/null 2>&1
```

## Troubleshooting

### Permission Issues

```bash
chmod -R 775 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache
```

### Clear Caches

```bash
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
```

## License

This project is proprietary software. All rights reserved.

## Support

For support, contact the development team.
