# Push Notifications Setup Guide

This guide explains how to set up Firebase Cloud Messaging (FCM) for real-time push notifications in the Afrilen Portal mobile app.

## Backend Setup (Laravel)

### 1. Add FCM Server Key to Environment

Add your Firebase Cloud Messaging server key to your `.env` file:

```env
FCM_SERVER_KEY=your_fcm_server_key_here
```

To get your FCM Server Key:
1. Go to [Firebase Console](https://console.firebase.google.com/)
2. Select your project
3. Go to Project Settings > Cloud Messaging
4. Copy the "Server key" under "Cloud Messaging API (Legacy)"

### 2. Run Database Migration

Run the migration to create the `device_tokens` table:

```bash
php artisan migrate
```

### 3. How It Works

- When a notification is created in the system (via `Notification::create()`), the `NotificationObserver` automatically sends push notifications to all registered devices for that user.
- Device tokens are registered when users log in to the mobile app.
- Push notifications are sent asynchronously to avoid blocking the main request.

## Mobile App Setup (Flutter)

### 1. Firebase Configuration

You need to add Firebase configuration files to your Flutter project:

#### For Android:
1. Download `google-services.json` from Firebase Console
2. Place it in `afrilen_mobile_app/android/app/`

#### For iOS:
1. Download `GoogleService-Info.plist` from Firebase Console
2. Place it in `afrilen_mobile_app/ios/Runner/`

### 2. Android Configuration

Add to `afrilen_mobile_app/android/build.gradle`:

```gradle
buildscript {
    dependencies {
        classpath 'com.google.gms:google-services:4.4.0'
    }
}
```

Add to `afrilen_mobile_app/android/app/build.gradle`:

```gradle
apply plugin: 'com.google.gms.google-services'
```

### 3. iOS Configuration

Add to `afrilen_mobile_app/ios/Podfile`:

```ruby
platform :ios, '12.0'
```

Then run:
```bash
cd ios && pod install
```

### 4. Permissions

The app automatically requests notification permissions when initialized. Users can grant or deny permissions.

### 5. How It Works

- On app launch, the `PushNotificationService` initializes and requests permissions.
- When a user logs in, their device token is registered with the backend.
- When a push notification is received:
  - **Foreground**: Shows a local notification
  - **Background**: Handled by background message handler
  - **Terminated**: Opens app when notification is tapped
- The `NotificationProvider` listens to push notifications and automatically refreshes the unread count.

## Testing

### Test Push Notification from Backend

You can test by creating a notification through the admin panel or API. The push notification should be sent automatically.

### Test Device Token Registration

1. Log in to the mobile app
2. Check the backend logs or database to verify the device token was registered
3. Send a test notification from the admin panel
4. Verify the notification appears on the device

## Troubleshooting

### Notifications Not Appearing

1. Check that FCM_SERVER_KEY is set correctly in `.env`
2. Verify device token is registered in the `device_tokens` table
3. Check Firebase Console for delivery status
4. Verify app has notification permissions

### Token Registration Fails

1. Check API authentication is working
2. Verify the `/api/v1/device-token/register` endpoint is accessible
3. Check device logs for error messages

### Background Notifications Not Working

1. Ensure `firebaseMessagingBackgroundHandler` is a top-level function
2. Check that the app is properly configured for background execution
3. Verify notification channel is created (Android)

## Security Notes

- FCM Server Key should be kept secret and never exposed in client-side code
- Device tokens are user-specific and should be invalidated on logout
- Consider implementing rate limiting for push notification sending

