# 🚀 cPanel Quick Deployment - Copy & Paste Commands

## ⚡ Fastest Method (Automated)

**After extracting files to your project directory, run:**

```bash
# Navigate to your project (replace with your path)
cd /home/yourusername/public_html

# Run the automated deployment script
php deploy-cpanel.php
```

**If that doesn't work, try with specific PHP version:**
```bash
/usr/bin/php81 deploy-cpanel.php
# OR
/usr/bin/php82 deploy-cpanel.php
```

---

## 📋 Manual Method (Step by Step)

**Copy and paste each command one at a time:**

### 1. Navigate to Project
```bash
cd /home/yourusername/public_html
```

### 2. Check PHP Version
```bash
php -v
```
**Note:** Must be 8.1+. If not, use `/usr/bin/php81` instead of `php` in all commands below.

### 3. Set Permissions
```bash
chmod -R 755 storage bootstrap/cache
```

### 4. Install Dependencies
```bash
composer install --no-dev --optimize-autoloader
```
**If composer not found, try:**
```bash
/usr/local/bin/composer install --no-dev --optimize-autoloader
```

### 5. Generate Key (if needed)
```bash
php artisan key:generate
```

### 6. Run Migrations
```bash
php artisan migrate --force
```

### 7. Clear Caches
```bash
php artisan optimize:clear
```

### 8. Rebuild Caches
```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

### 9. Create Storage Link
```bash
php artisan storage:link
```

### 10. Verify
```bash
php artisan --version
```

---

## 🔧 Common cPanel Issues & Fixes

### Issue: "composer: command not found"
**Solution:**
```bash
# Try these paths:
/usr/local/bin/composer install --no-dev --optimize-autoloader
# OR
/opt/cpanel/composer/bin/composer install --no-dev --optimize-autoloader
```

### Issue: "PHP version too old"
**Solution:** Use specific PHP version:
```bash
# Replace 'php' with your PHP path in all commands
/usr/bin/php81 artisan migrate --force
/usr/bin/php82 artisan migrate --force
```

### Issue: "Permission denied"
**Solution:**
```bash
chmod -R 755 storage bootstrap/cache
chown -R $(whoami) storage bootstrap/cache
```

### Issue: "Database connection failed"
**Solution:**
```bash
# Check .env file
cat .env | grep DB_
# Verify credentials are correct
```

---

## ✅ Success Checklist

After deployment, verify:

- [ ] `php artisan --version` shows version
- [ ] No errors in `storage/logs/laravel.log`
- [ ] Website loads
- [ ] API responds (test with Postman)

---

## 🆘 Need Help?

**Check the log:**
```bash
tail -n 100 storage/logs/laravel.log
```

**Test database connection:**
```bash
php artisan tinker
# Then type: DB::connection()->getPdo();
```

