# 🚀 cPanel Terminal Deployment - Step by Step Guide

## Prerequisites
- Files already extracted to your project directory
- Access to cPanel Terminal (SSH)
- Your project directory path (usually `/home/username/public_html` or `/home/username/domain.com`)

---

## Step 1: Navigate to Your Project Directory

```bash
# Replace with your actual project path
cd /home/yourusername/public_html
# OR
cd /home/yourusername/yourdomain.com
# OR wherever your Laravel project is located
```

**Verify you're in the right place:**
```bash
ls -la
# You should see: artisan, app/, config/, database/, etc.
```

---

## Step 2: Check PHP Version

```bash
php -v
```

**Required:** PHP 8.1 or higher. If you see PHP 7.x, you need to use a different PHP version.

**If PHP version is too old, use:**
```bash
# Try different PHP versions (common on cPanel)
/usr/bin/php81 -v
/usr/bin/php82 -v
/usr/bin/php83 -v
```

**Note which PHP version works** - you'll use it for all commands below.

---

## Step 3: Verify .env File Exists

```bash
ls -la .env
```

**If .env doesn't exist:**
```bash
# Copy from example
cp .env.example .env

# Then edit it with your database credentials
nano .env
# OR use cPanel File Manager to edit
```

**If .env exists, verify it has correct database settings:**
```bash
grep DB_ .env
```

---

## Step 4: Set Proper File Permissions

```bash
# Make storage and cache directories writable
chmod -R 755 storage
chmod -R 755 bootstrap/cache

# If you have ownership issues (replace 'yourusername' with your cPanel username)
chown -R yourusername:yourusername storage bootstrap/cache
```

---

## Step 5: Install/Update Composer Dependencies

```bash
# Check if composer is available
composer --version
```

**If composer is not found, use full path:**
```bash
# Common cPanel composer paths
/usr/local/bin/composer install --no-dev --optimize-autoloader
# OR
/opt/cpanel/composer/bin/composer install --no-dev --optimize-autoloader
# OR
php composer.phar install --no-dev --optimize-autoloader
```

**If using specific PHP version:**
```bash
/usr/bin/php81 /usr/local/bin/composer install --no-dev --optimize-autoloader
```

**Wait for installation to complete** (this may take 2-5 minutes)

---

## Step 6: Generate Application Key (if needed)

```bash
php artisan key:generate
```

**If using specific PHP version:**
```bash
/usr/bin/php81 artisan key:generate
```

---

## Step 7: Run Database Migrations (SAFE - Won't Break Database)

```bash
# Check migration status first
php artisan migrate:status
```

**Run migrations:**
```bash
php artisan migrate --force
```

**If using specific PHP version:**
```bash
/usr/bin/php81 artisan migrate --force
```

**Expected output:** Should show "Nothing to migrate" or list new migrations being run.

---

## Step 8: Clear All Caches

```bash
php artisan optimize:clear
```

**If using specific PHP version:**
```bash
/usr/bin/php81 artisan optimize:clear
```

**This clears:**
- Application cache
- Configuration cache
- Route cache
- View cache
- Compiled classes

---

## Step 9: Rebuild Optimized Caches (for Production)

```bash
php artisan config:cache
php artisan route:cache
php artisan view:cache
```

**If using specific PHP version:**
```bash
/usr/bin/php81 artisan config:cache
/usr/bin/php81 artisan route:cache
/usr/bin/php81 artisan view:cache
```

---

## Step 10: Set Storage Link (if needed)

```bash
php artisan storage:link
```

**If using specific PHP version:**
```bash
/usr/bin/php81 artisan storage:link
```

---

## Step 11: Verify Deployment

```bash
# Check Laravel version
php artisan --version

# Check if there are any errors
tail -n 50 storage/logs/laravel.log
```

**Test API endpoint:**
```bash
curl https://yourdomain.com/api/v1/auth/user
# Should return JSON (may show authentication error, which is normal)
```

---

## Step 12: Check File Permissions Again

```bash
# Verify storage is writable
ls -la storage/
ls -la storage/logs/
ls -la storage/framework/

# All should show 755 or 775 permissions
```

---

## 🎯 Quick Command Reference (Copy-Paste Ready)

**Replace `/usr/bin/php81` with your PHP path if different:**

```bash
# 1. Navigate
cd /home/yourusername/public_html

# 2. Permissions
chmod -R 755 storage bootstrap/cache

# 3. Install dependencies
/usr/local/bin/composer install --no-dev --optimize-autoloader

# 4. Generate key (if needed)
php artisan key:generate

# 5. Run migrations
php artisan migrate --force

# 6. Clear caches
php artisan optimize:clear

# 7. Rebuild caches
php artisan config:cache
php artisan route:cache
php artisan view:cache

# 8. Storage link
php artisan storage:link

# 9. Verify
php artisan --version
```

---

## ⚠️ Common Issues & Solutions

### Issue 1: "Composer command not found"
```bash
# Use full path
/usr/local/bin/composer install --no-dev --optimize-autoloader
# OR download composer
curl -sS https://getcomposer.org/installer | php
php composer.phar install --no-dev --optimize-autoloader
```

### Issue 2: "Permission denied"
```bash
# Fix permissions
chmod -R 755 storage bootstrap/cache
chown -R yourusername:yourusername storage bootstrap/cache
```

### Issue 3: "PHP version too old"
```bash
# Use specific PHP version for all commands
/usr/bin/php81 artisan migrate --force
/usr/bin/php82 artisan migrate --force
# etc.
```

### Issue 4: "Database connection failed"
```bash
# Check .env file
cat .env | grep DB_
# Verify database credentials are correct
```

### Issue 5: "Class not found" or "Autoload errors"
```bash
# Regenerate autoload files
composer dump-autoload
# OR
php composer.phar dump-autoload
```

### Issue 6: "Migration already exists"
```bash
# This is normal - Laravel tracks which migrations ran
php artisan migrate:status
# Shows which migrations have been executed
```

---

## ✅ Post-Deployment Checklist

After completing all steps, verify:

- [ ] `php artisan --version` shows Laravel version
- [ ] `storage/logs/laravel.log` has no errors
- [ ] API endpoints respond (test with curl or Postman)
- [ ] Website loads without errors
- [ ] Database connection works
- [ ] File uploads work (if applicable)

---

## 📞 Need Help?

If you encounter errors:

1. **Check the log file:**
   ```bash
   tail -n 100 storage/logs/laravel.log
   ```

2. **Verify PHP version:**
   ```bash
   php -v
   ```

3. **Check file permissions:**
   ```bash
   ls -la storage/
   ls -la bootstrap/cache/
   ```

4. **Verify database connection:**
   ```bash
   php artisan tinker
   # Then in tinker:
   DB::connection()->getPdo();
   # Should show connection info or error
   ```

---

## 🎉 Success!

If all steps completed without errors, your deployment is successful!

**Next steps:**
- Test your API endpoints
- Verify all features work
- Monitor logs for any issues
- Keep a backup of your current working state

